/**
 * Wraps `addEventListener` and `removeEventListener` on: global scope; the prototype of `XMLHttpRequest`, and
 * `document` (if in a browser scope). Adds custom events in context of a new emitter scoped only to these methods.
 * @param {Object} sharedEE - The shared event emitter on which a new scoped
 *     event emitter will be based.
 * @returns {Object} Scoped event emitter with a debug ID of `events`.
 */
export function wrapEvents(sharedEE: Object): Object;
/**
 * Returns an event emitter scoped specifically for the `events` context. This scoping is a remnant from when all the
 * features shared the same group in the event, to isolate events between features. It will likely be revisited.
 * @param {Object} sharedEE - Optional event emitter on which to base the scoped emitter.
 *     Uses `ee` on the global scope if undefined).
 * @returns {Object} Scoped event emitter with a debug ID of 'events'.
 */
export function scopedEE(sharedEE: Object): Object;
//# sourceMappingURL=wrap-events.d.ts.map