/**
 * Wraps the `fetch` method of the global scope for instrumentation. Also wraps the prototypes of the async methods
 * that parse Request and Response bodies to generate start and end events for each, in context of a new event
 * emitter scoped only to fetch and related methods.
 * @param {Object} sharedEE - The shared event emitter on which a new scoped
 *     event emitter will be based.
 * @returns {Object} Scoped event emitter with a debug ID of `fetch`.
 */
export function wrapFetch(sharedEE: Object): Object;
/**
 * Returns an event emitter scoped specifically for the `fetch` context. This scoping is a remnant from when all the
 * features shared the same group in the event, to isolate events between features. It will likely be revisited.
 * @param {Object} sharedEE - Optional event emitter on which to base the scoped emitter.
 *     Uses `ee` on the global scope if undefined).
 * @returns {Object} Scoped event emitter with a debug ID of 'fetch'.
 */
export function scopedEE(sharedEE: Object): Object;
//# sourceMappingURL=wrap-fetch.d.ts.map