/**
 * In web environments only, wraps the `window.MutationObserver` function to emit events on start, end, and error, in
 * the context of a new event emitter scoped only to mutations.
 * @param {Object} sharedEE - The shared event emitter on which a new scoped event emitter will be based.
 * @returns {Object} Scoped event emitter with a debug ID of `mutation`.
 */
export function wrapMutation(sharedEE: Object): Object;
/**
 * Returns an event emitter scoped specifically for the `mutation` context. This scoping is a remnant from when all the
 * features shared the same group in the event, to isolate events between features. It will likely be revisited.
 * @param {Object} sharedEE - Optional event emitter on which to base the scoped emitter.
 *     Uses `ee` on the global scope if undefined).
 * @returns {Object} Scoped event emitter with a debug ID of 'mutation'.
 */
export function scopedEE(sharedEE: Object): Object;
//# sourceMappingURL=wrap-mutation.d.ts.map