/**
 * Wraps the native Promise object so that it will emit events for start, end and error in the context of a new event
 * emitter scoped only to promise methods. Also instruments various methods, such as `all`, `race`, `resolve`,
 * `reject`, `then`, and `catch`.
 * @param {Object} sharedEE - The shared event emitter on which a new scoped event emitter will be based.
 * @returns {Object} Scoped event emitter with a debug ID of `promise`.
 */
export function wrapPromise(sharedEE: Object): Object;
/**
 * Returns an event emitter scoped specifically for the `promise` context. This scoping is a remnant from when all the
 * features shared the same group in the event, to isolate events between features. It will likely be revisited.
 * @param {Object} sharedEE - Optional event emitter on which to base the scoped emitter.
 *     Uses `ee` on the global scope if undefined).
 * @returns {Object} Scoped event emitter with a debug ID of 'promise'.
 */
export function scopedEE(sharedEE: Object): Object;
//# sourceMappingURL=wrap-promise.d.ts.map