/**
 * Wraps the global `setTimeout`, `setImmediate`, `setInterval`, `clearTimeout`, and `clearImmediate` functions to emit
 * events on start, end, and error, in the context of a new event emitter scoped only to timer functions. Also wraps
 * the callbacks of `setTimeout` and `setInterval`.
 * @param {Object} sharedEE - The shared event emitter on which a new scoped event emitter will be based.
 * @returns {Object} Scoped event emitter with a debug ID of `timer`.
 */
export function wrapTimer(sharedEE: Object): Object;
/**
 * Returns an event emitter scoped specifically for the `timer` context. This scoping is a remnant from when all the
 * features shared the same group in the event, to isolate events between features. It will likely be revisited.
 * @param {Object} sharedEE - Optional event emitter on which to base the scoped emitter.
 *     Uses `ee` on the global scope if undefined).
 * @returns {Object} Scoped event emitter with a debug ID of 'timer'.
 */
export function scopedEE(sharedEE: Object): Object;
//# sourceMappingURL=wrap-timer.d.ts.map