/**
 * Wraps the native XMLHttpRequest (XHR) object to emit custom events to its readystatechange event and an assortment
 * of handlers. Adds instrumentation in context of a new event emitter scoped only to XHR.
 * @param {Object} sharedEE - The shared event emitter on which a new scoped event emitter will be based.
 * @returns {Object} Scoped event emitter with a debug ID of `xhr`.
 */
export function wrapXhr(sharedEE: Object): Object;
/**
 * Returns an event emitter scoped specifically for the `xhr` context. This scoping is a remnant from when all the
 * features shared the same group in the event, to isolate events between features. It will likely be revisited.
 * @param {Object} sharedEE - Optional event emitter on which to base the scoped emitter.
 *     Uses `ee` on the global scope if undefined).
 * @returns {Object} Scoped event emitter with a debug ID of 'xhr'.
 */
export function scopedEE(sharedEE: Object): Object;
//# sourceMappingURL=wrap-xhr.d.ts.map