/**
 * @typedef {object} GQLMetadata
 * @property {string} operationName Name of the operation
 * @property {string} operationType Type of the operation
 * @property {string} operationFramework Framework responsible for the operation
 */
/**
 * Parses and returns the graphql metadata from a network request. If the network
 * request is not a graphql call, undefined will be returned.
 * @param {object|string} body Ajax request body
 * @param {string} query Ajax request query param string
 * @returns {GQLMetadata | undefined}
 */
export function parseGQL({ body, query }?: object | string): GQLMetadata | undefined;
export type GQLMetadata = {
    /**
     * Name of the operation
     */
    operationName: string;
    /**
     * Type of the operation
     */
    operationType: string;
    /**
     * Framework responsible for the operation
     */
    operationFramework: string;
};
//# sourceMappingURL=gql.d.ts.map