/**
 * Given a function name string, extracts only an alphanumeric segment at the end of the string (if one exists).
 * This is useful for stack traces, where functions might not be named (e.g., anonymous, computed).
 *
 * @param {string} functionNameString - The original function name string.
 * @returns {string|undefined} The canonical function name, or undefined if the input is falsy or no alphanumeric segments are found.
 */
export function canonicalFunctionName(functionNameString: string): string | undefined;
//# sourceMappingURL=canonical-function-name.d.ts.map