/**
 * Represents an error with a stack trace.
 * @typedef {Object} StackInfo
 * @property {string} name - The name of the error (e.g. 'TypeError').
 * @property {string} message - The error message.
 * @property {string} stackString - The stack trace as a string.
 * @property {Array<Object>} frames - An array of frames in the stack trace.
 * @property {string} frames.url - The URL of the file containing the code for the frame.
 * @property {string} frames.func - The name of the function associated with the frame.
 * @property {number} frames.line - The line number of the code in the frame.
 */
/**
 * Attempts to compute a stack trace for the given exception.
 * @param {Error} ex - The exception for which to compute the stack trace.
 * @returns {StackInfo} A stack trace object containing information about the frames on the stack.
 */
export function computeStackTrace(ex: Error): StackInfo;
/**
 * Represents an error with a stack trace.
 */
export type StackInfo = {
    /**
     * - The name of the error (e.g. 'TypeError').
     */
    name: string;
    /**
     * - The error message.
     */
    message: string;
    /**
     * - The stack trace as a string.
     */
    stackString: string;
    /**
     * - An array of frames in the stack trace.
     */
    frames: Array<Object>;
    /**
     * - The URL of the file containing the code for the frame.
     */
    url: string;
    /**
     * - The name of the function associated with the frame.
     */
    func: string;
    /**
     * - The line number of the code in the frame.
     */
    line: number;
};
//# sourceMappingURL=compute-stack-trace.d.ts.map