/**
 * @typedef {import('./compute-stack-trace.js').StackInfo} StackInfo
 */
export class Aggregate extends AggregateBase {
    static featureName: string;
    constructor(agentIdentifier: any, aggregator: any);
    stackReported: {};
    observedAt: {};
    pageviewReported: {};
    bufferedErrorsUnderSpa: {};
    currentBody: {} | null | undefined;
    errorOnPage: boolean;
    onHarvestStarted(options: any): {
        body: {} | null;
        qs: {};
    };
    onHarvestFinished(result: any): void;
    nameHash(params: any): number;
    getBucketName(objType: any, params: any, customParams: any): string;
    /**
     * Builds a standardized stack trace string from the frames in the given `stackInfo` object, with each frame separated
     * by a newline character. Lines take the form `<functionName>@<url>:<lineNumber>`.
     *
     * @param {StackInfo} stackInfo - An object specifying a stack string and individual frames.
     * @returns {string} A canonical stack string built from the URLs and function names in the given `stackInfo` object.
     */
    buildCanonicalStackString(stackInfo: StackInfo): string;
    storeError(err: any, time: any, internal: any, customAttributes: any): void;
    onInteractionDone(interaction: any, wasSaved: any): void;
    onSoftNavNotification(interactionId: any, wasFinished: any, softNavAttrs: any): void;
    #private;
}
export type StackInfo = import('./compute-stack-trace.js').StackInfo;
import { AggregateBase } from '../../utils/aggregate-base';
//# sourceMappingURL=index.d.ts.map