export class Aggregate extends AggregateBase {
    static featureName: string;
    constructor(agentIdentifier: any, aggregator: any, args: any);
    /** The interval to harvest at.  This gets overridden if the size of the payload exceeds certain thresholds */
    harvestTimeSeconds: any;
    /** Set once the recorder has fully initialized after flag checks and sampling */
    initialized: boolean;
    /** populated with the gzipper lib async */
    gzipper: typeof import("fflate").gzipSync | undefined;
    /** populated with the u8 string lib async */
    u8: typeof import("fflate").strToU8 | undefined;
    mode: any;
    /** set by BCS response */
    entitled: boolean;
    recorder: any;
    scheduler: HarvestScheduler;
    errorNoticed: boolean;
    switchToFull(): void;
    /**
     * Evaluate entitlements and sampling before starting feature mechanics, importing and configuring recording library, and setting storage state
     * @param {boolean} entitlements - the true/false state of the "sr" flag from RUM response
     * @param {boolean} errorSample - the true/false state of the error sampling decision
     * @param {boolean} fullSample - the true/false state of the full sampling decision
     * @param {boolean} ignoreSession - whether to force the method to ignore the session state and use just the sample flags
     * @returns {void}
     */
    initializeRecording(errorSample: boolean, fullSample: boolean, ignoreSession: boolean): void;
    prepUtils(): Promise<void>;
    prepareHarvest({ opts }?: {
        opts: any;
    }): {
        qs: {
            browser_monitoring_key: any;
            type: string;
            app_id: any;
            protocol_version: string;
            attributes: string;
        };
        body: any;
    }[] | undefined;
    getHarvestContents(recorderEvents: any): {
        qs: {
            browser_monitoring_key: any;
            type: string;
            app_id: any;
            protocol_version: string;
            attributes: string;
        };
        body: any;
    };
    onHarvestFinished(result: any): void;
    /**
     * Forces the agent into OFF mode so that changing tabs or navigating
     * does not restart the recording. This is used when the customer calls
     * the stopRecording API.
     */
    forceStop(forceHarvest: any): void;
    /** Abort the feature, once aborted it will not resume */
    abort(reason?: {}): void;
    syncWithSessionManager(state?: {}): void;
}
import { AggregateBase } from '../../utils/aggregate-base';
import { HarvestScheduler } from '../../../common/harvest/harvest-scheduler';
//# sourceMappingURL=index.d.ts.map