export class RecorderEvents {
    /** The buffer to hold recorder event nodes */
    events: any[];
    /** Payload metadata -- Should indicate when a replay blob started recording.  Resets each time a harvest occurs.
     * cycle timestamps are used as fallbacks if event timestamps cannot be used
     */
    cycleTimestamp: number;
    /** A value which increments with every new mutation node reported. Resets after a harvest is sent */
    payloadBytesEstimation: number;
    /** Payload metadata -- Should indicate that the payload being sent has a full DOM snapshot. This can happen
     * -- When the recording library begins recording, it starts by taking a DOM snapshot
     * -- When visibility changes from "hidden" -> "visible", it must capture a full snapshot for the replay to work correctly across tabs
    */
    hasSnapshot: boolean;
    /** Payload metadata -- Should indicate that the payload being sent has a meta node. The meta node should always precede a snapshot node. */
    hasMeta: boolean;
    /** Payload metadata -- Should indicate that the payload being sent contains an error.  Used for query/filter purposes in UI */
    hasError: boolean;
    /** Payload metadata -- Denotes whether all stylesheet elements were able to be inlined */
    inlinedAllStylesheets: boolean;
    add(event: any): void;
}
//# sourceMappingURL=recorder-events.d.ts.map