export class Recorder {
    constructor(parent: any);
    /** True when actively recording, false when paused or stopped */
    recording: boolean;
    /** The pointer to the current bucket holding rrweb events */
    currentBufferTarget: RecorderEvents;
    /** Hold on to the last meta node, so that it can be re-inserted if the meta and snapshot nodes are broken up due to harvesting */
    lastMeta: boolean;
    /** The parent class that instantiated the recorder */
    parent: any;
    /** Config to inform to inline stylesheet contents (true default) */
    shouldInlineStylesheets: any;
    /** A flag that can be set to false by failing conversions to stop the fetching process */
    shouldFix: any;
    /** The method to stop recording. This defaults to a noop, but is overwritten once the recording library is imported and initialized */
    stopRecording: () => void;
    getEvents(): {
        type: string;
        events: any[];
        cycleTimestamp: number;
        payloadBytesEstimation: number;
        hasSnapshot: boolean;
        hasMeta: boolean;
        hasError: boolean;
        inlinedAllStylesheets: boolean;
    };
    /** Clears the buffer (this.#events), and resets all payload metadata properties */
    clearBuffer(): void;
    /** Begin recording using configured recording lib */
    startRecording(): void;
    /**
     * audit - Checks if the event node payload is missing certain attributes
     * will forward on to the "store" method if nothing needs async fixing
     * @param {*} event - An RRWEB event node
     * @param {*} isCheckout - Flag indicating if the payload was triggered as a checkout
     */
    audit(event: any, isCheckout: any): void;
    /** Store a payload in the buffer (this.#events).  This should be the callback to the recording lib noticing a mutation */
    store(event: any, isCheckout: any): void;
    /** force the recording lib to take a full DOM snapshot.  This needs to occur in certain cases, like visibility changes */
    takeFullSnapshot(): void;
    clearTimestamps(): void;
    /** Estimate the payload size */
    getPayloadSize(newBytes?: number): any;
    /** Extensive research has yielded about an 88% compression factor on these payloads.
     * This is an estimation using that factor as to not cause performance issues while evaluating
     * https://staging.onenr.io/037jbJWxbjy
     * */
    estimateCompression(data: any): any;
    #private;
}
import { RecorderEvents } from './recorder-events';
//# sourceMappingURL=recorder.d.ts.map