export const stylesheetEvaluator: StylesheetEvaluator;
declare class StylesheetEvaluator {
    /**
    * Flipped to true if stylesheets that cannot be natively inlined are detected by the stylesheetEvaluator class
    * Used at harvest time to denote that all subsequent payloads are subject to this and customers should be advised to handle crossorigin decoration
    * */
    invalidStylesheetsDetected: boolean;
    failedToFix: number;
    /**
     * this works by checking (only ever once) each cssRules obj in the style sheets array. The try/catch will catch an error if the cssRules obj blocks access, triggering the module to try to "fix" the asset`. Returns the count of incomplete assets discovered.
     * @returns {Number}
     */
    evaluate(): number;
    /**
     * Resolves promise once all stylesheets have been fetched and overridden
     * @returns {Promise}
     */
    fix(): Promise<any>;
    #private;
}
export {};
//# sourceMappingURL=stylesheet-evaluator.d.ts.map