export class Aggregate extends AggregateBase {
    static featureName: string;
    constructor(agentIdentifier: any, aggregator: any, argsObj: any);
    agentRuntime: any;
    resourceObserver: any;
    ptid: string | undefined;
    trace: {} | undefined;
    nodeCount: number | undefined;
    sentTrace: {} | null | undefined;
    harvestTimeSeconds: any;
    maxNodesPerHarvest: any;
    /**
     * Standalone (mode) refers to the legacy version of ST before the idea of 'session' or the Replay feature existed.
     * It has some different behavior vs when used in tandem with replay. */
    isStandalone: boolean | undefined;
    operationalGate: HandlerCache | undefined;
    startTracing(startupBuffer: any, dontStartHarvestYet?: boolean): void;
    processPVT(name: any, value: any, attrs: any): void;
    storeTiming(timingEntry: any): void;
    storeEvent(currentEvent: any, target: any, start: any, end: any): void;
    shouldIgnoreEvent(event: any, target: any): boolean;
    evtName(type: any): any;
    evtOrigin(t: any, target: any): string;
    storeHist(path: any, old: any, time: any): void;
    storeResources(resources: any): void;
    storeErrorAgg(type: any, name: any, params: any, metrics: any): void;
    storeXhrAgg(type: any, name: any, params: any, metrics: any): void;
    storeSTN(stn: any): void;
    /**
     * Trim the collection of nodes awaiting harvest such that those seen outside a certain span of time are discarded.
     * @param {number} lookbackDuration Past length of time until now for which we care about nodes, in milliseconds
     * @returns {number} However many nodes were discarded after trimming.
     */
    trimSTNs(lookbackDuration: number): number;
    takeSTNs(retry: any): {
        qs?: undefined;
        body?: undefined;
    } | {
        qs: {
            fsh?: number | undefined;
            st: any;
            /** hr === "hasReplay" in NR1, standalone is always checked and processed before harvesting
             * so a race condition between ST and SR states should not be a concern if implemented here */
            hr: number;
            /** fts === "firstTimestamp" in NR1, indicates what the earliest NODE timestamp was
             * so that blob parsing doesn't need to happen to support UI/API functions  */
            fts: any;
            /** n === "nodeCount" in NR1, a count of nodes in the ST payload, so that blob parsing doesn't need to happen to support UI/API functions */
            n: number;
        };
        body: {
            res: any[];
        };
    };
    smearEvtsByOrigin(name: any): (byOrigin: any, evtNode: any) => any;
    #private;
}
import { AggregateBase } from '../../utils/aggregate-base';
import { HandlerCache } from '../../utils/handler-cache';
//# sourceMappingURL=index.d.ts.map