export class Aggregate extends AggregateBase {
    static featureName: string;
    constructor(agentIdentifier: any, aggregator: any, { domObserver }: {
        domObserver: any;
    });
    interactionsToHarvest: any[];
    interactionsAwaitingRetry: any[];
    domObserver: any;
    initialPageLoadInteraction: InitialPageLoadInteraction;
    latestRouteSetByApi: any;
    interactionInProgress: Interaction | null;
    onHarvestStarted(options: any): {
        body: {
            e: string;
        };
    } | undefined;
    onHarvestFinished(result: any): void;
    startUIInteraction(eventName: any, startedAt: any, sourceElem: any): void;
    setClosureHandlers(): void;
    /**
     * Find the active interaction (current or past) for a given timestamp. Note that historic lookups mostly only go as far back as the last harvest for this feature.
     * Also, the caller should check the status of the interaction returned if found via {@link Interaction.status}, if that's pertinent.
     * TIP: Cancelled (status) interactions are NOT returned!
     * IMPORTANT: Finished interactions are in queue for next harvest! It's highly recommended that consumer logic be synchronous for safe reference.
     * @param {DOMHighResTimeStamp} timestamp
     * @returns An {@link Interaction} or undefined, if no active interaction was found.
     */
    getInteractionFor(timestamp: DOMHighResTimeStamp): any;
    #private;
}
import { AggregateBase } from '../../utils/aggregate-base';
import { InitialPageLoadInteraction } from './initial-page-load-interaction';
import { Interaction } from './interaction';
//# sourceMappingURL=index.d.ts.map