/**
 * link https://github.com/newrelic/nr-querypack/blob/main/schemas/bel/7.qpschema
 **/
export class Interaction extends BelNode {
    constructor(agentIdentifier: any, uiEvent: any, uiEventTimestamp: any, currentRouteKnown: any);
    id: string;
    initialPageURL: string;
    oldURL: string;
    newURL: string;
    customName: any;
    customAttributes: {};
    customDataByApi: {};
    queueTime: any;
    appTime: any;
    newRoute: any;
    /** Internal state of this interaction: in-progress, finished, or cancelled. */
    status: string;
    domTimestamp: number;
    historyTimestamp: number;
    createdByApi: boolean;
    keepOpenUntilEndApi: boolean;
    onDone: any[];
    cancellationTimer: any;
    belType: number;
    trigger: any;
    start: any;
    oldRoute: any;
    eventSubscription: Map<string, never[]>;
    forceSave: boolean;
    forceIgnore: boolean;
    updateDom(timestamp: any): void;
    updateHistory(timestamp: any, newUrl: any): void;
    seenHistoryAndDomChange(): boolean;
    on(event: any, cb: any): void;
    done(customEndTime: any): boolean;
    /**
     * Given a timestamp, determine if it falls within this interaction's span, i.e. if this was the active interaction during that time.
     * For in-progress interactions, this only compares the time with the start of span. Cancelled interactions are not considered active at all.
     * @param {DOMHighResTimeStamp} timestamp
     * @returns True or false boolean.
     */
    isActiveDuring(timestamp: DOMHighResTimeStamp): boolean;
    get firstPaint(): void;
    get firstContentfulPaint(): void;
    get navTiming(): void;
    serialize(firstStartTimeOfPayload: any): string;
    #private;
}
import { BelNode } from './bel-node';
//# sourceMappingURL=interaction.d.ts.map