/**
 * A class to defer callback execution until a decision can be reached
 */
export class HandlerCache {
    /**
     * Wrap callback functions with this method to defer their execution until a decision has been reached
     * @param {Function} handler
     * @returns {void}
     */
    settle(handler: Function): void;
    /**
     * Make a decision about what to do with the cache of callbacks.
     * --- if true: tell the handlerCache that its ok to immediately execute the callbacks that are triggered by the ee from this moment on
     * and execute all the storage callbacks saved up in the handlerCache ---
     * --- if false: tell the handlerCache not to execute any of the storage callbacks
     * and wipe out all the storage callbacks saved up in the handlerCache
     * @param {boolean} decision
     */
    decide(decision: boolean): void;
    permanentlyDecide(decision: any): void;
    #private;
}
//# sourceMappingURL=handler-cache.d.ts.map