/**
 * Base class for instrumenting a feature.
 * @extends FeatureBase
 */
export class InstrumentBase extends FeatureBase {
    /**
     * Instantiate InstrumentBase.
     * @param {string} agentIdentifier - The unique ID of the instantiated agent (relative to global scope).
     * @param {import('../../common/aggregate/aggregator').Aggregator} aggregator - The shared Aggregator that will handle batching and reporting of data.
     * @param {string} featureName - The name of the feature module (used to construct file path).
     * @param {boolean} [auto=true] - Determines whether the feature should automatically register to have the draining
     *     of its pooled instrumentation data handled by the agent's centralized drain functionality, rather than draining
     *     immediately. Primarily useful for fine-grained control in tests.
     */
    constructor(agentIdentifier: string, aggregator: import('../../common/aggregate/aggregator').Aggregator, featureName: string, auto?: boolean | undefined);
    auto: boolean;
    /** @type {Function | undefined} This should be set by any derived Instrument class if it has things to do when feature fails or is killed. */
    abortHandler: Function | undefined;
    /**
     * @type {import('./aggregate-base').AggregateBase} Holds the reference to the feature's aggregate module counterpart, if and after it has been initialized. This may not be assigned until after page loads!
     * The only purpose of this for now is to expose it to the NREUM interface, as the feature's instrument instance is already exposed.
    */
    featAggregate: import('./aggregate-base').AggregateBase;
    /**
     * @type {Promise} Assigned immediately after @see importAggregator runs. Serves as a signal for when the inner async fn finishes execution. Useful for features to await
     * one another if there are inter-features dependencies.
    */
    onAggregateImported: Promise<any>;
    /**
     * Lazy-load the latter part of the feature: its aggregator. This method is called by the first part of the feature
     * (the instrumentation) when instrumentation is complete.
     * @param {Object} [argsObjFromInstrument] - any values or references to pass down to aggregate
     * @returns void
     */
    importAggregator(argsObjFromInstrument?: Object | undefined): void;
    #private;
}
import { FeatureBase } from './feature-base';
//# sourceMappingURL=instrument-base.d.ts.map