/**
 * Centralizes the lazy loading of agent feature aggregate and instrument sources.
 *
 * This function uses two defined switch cases to allow us to easily name our chunks and re-use these
 * chunks for different agent types. We do not use template strings or string concatenation here because
 * doing so makes it much more difficult to name the chunks and forces Webpack to "guess" what the chunks
 * should be.
 * @param featureName Name of the feature to import such as ajax or session_trace
 * @param featurePart Name of the feature part to load; should be either instrument or aggregate
 * @returns {Promise<InstrumentBase|FeatureBase|null>}
 */
export function lazyFeatureLoader(featureName: any, featurePart: any): Promise<InstrumentBase | FeatureBase | null>;
//# sourceMappingURL=lazy-feature-loader.d.ts.map