export function setTopLevelCallers(): void;
export function setAPI(agentIdentifier: any, forceDrain: any, runSoftNavOverSpa?: boolean): {
    addPageAction: (...args: any[]) => any;
    setPageViewName(name: any, host: any): any;
    setCustomAttribute(name: any, value: any, persistAttribute?: boolean): any;
    /**
     * Attach the 'enduser.id' attribute onto agent payloads. This may be used in NR queries to group all browser events by specific users.
     * @param {string} value - unique user identifier; a null user id suggests none should exist
     * @returns @see apiCall
     */
    setUserId(value: string): any;
    /**
     * Attach the 'applcation.version' attribute onto agent payloads. This may be used in NR queries to group all browser events by a specific customer-defined release.
     * @param {string|null} value - Application version -- if null, will "unset" the value
     * @returns @see apiCall
     */
    setApplicationVersion(value: string | null): any;
    start(features: any): void;
    interaction(options: any): any;
    setCurrentRouteName: (...args: any[]) => any;
    noticeError(err: any, customAttributes: any): void;
};
//# sourceMappingURL=api.d.ts.map