/**
 * A minimal agent class designed to only respond to manual user input. As such, this class does not
 * automatically instrument. Instead, each MicroAgent instance will lazy load the required features and can support loading multiple instances on one page.
 * Out of the box, it can manually handle and report Page View, Page Action, and Error events.
 */
export class MicroAgent extends AgentBase {
    /**
     * @param {Object} options - Specifies features and runtime configuration,
     * @param {string=} agentIdentifier - The optional unique ID of the agent.
     */
    constructor(options: Object, agentIdentifier?: string | undefined);
    sharedAggregator: Aggregator;
    features: {};
    /**
     * Starts a set of agent features if not running in "autoStart" mode
     * {@link https://docs.newrelic.com/docs/browser/new-relic-browser/browser-apis/start/}
     * @param {string|string[]|undefined} name The feature name(s) to start.  If no name(s) are passed, all features will be started
     */
    start: (features: any) => boolean | void;
    get config(): {
        info: any;
        init: any;
        loader_config: any;
        runtime: any;
    };
    run(features: any): boolean | void;
}
import { AgentBase } from './agent-base';
import { Aggregator } from '../common/aggregate/aggregator';
//# sourceMappingURL=micro-agent.d.ts.map