'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var BatchDeleteController = function () {
    function BatchDeleteController($scope, $state, $translate, WriteQueries, progression, notification, view) {
        _classCallCheck(this, BatchDeleteController);

        this.$scope = $scope;
        this.$state = $state;
        this.$translate = $translate;
        this.WriteQueries = WriteQueries;
        this.progression = progression;
        this.notification = notification;
        this.view = view;
        this.entity = view.getEntity();
        this.entityIds = $state.params.ids;
        this.selection = []; // fixme: query db to get selection
        this.title = view.title();
        this.description = view.description();
        this.actions = view.actions();
        this.loadingPage = false;
        this.fields = view.fields();

        $scope.$on('$destroy', this.destroy.bind(this));
    }

    _createClass(BatchDeleteController, [{
        key: 'batchDelete',
        value: function batchDelete() {
            var _this = this;

            var entityName = this.entity.name();
            var $translate = this.$translate,
                $state = this.$state,
                progression = this.progression,
                notification = this.notification;

            progression.start();
            return this.WriteQueries.batchDelete(this.view, this.entityIds).then(function () {
                return $state.go($state.get('list'), angular.extend({ entity: entityName }, $state.params));
            })
            // no need to call progression.done() in case of success, as it's called by the view dislayed afterwards
            .then(function () {
                return $translate('BATCH_DELETE_SUCCESS');
            }).then(function (text) {
                return notification.log(text, { addnCls: 'humane-flatty-success' });
            }).catch(function (error) {
                var errorMessage = _this.config.getErrorMessageFor(_this.view, error) || 'ERROR_MESSAGE';
                progression.done();

                $translate(errorMessage, {
                    status: error && error.status,
                    details: error && error.data && _typeof(error.data) === 'object' ? JSON.stringify(error.data) : {}
                }).catch(angular.identity) // See https://github.com/angular-translate/angular-translate/issues/1516
                .then(function (text) {
                    return notification.log(text, { addnCls: 'humane-flatty-error' });
                });
            });
        }
    }, {
        key: 'back',
        value: function back() {
            this.$state.go(this.$state.get('list'), angular.extend({
                entity: this.entity.name()
            }, this.$state.params));
        }
    }, {
        key: 'destroy',
        value: function destroy() {
            this.$scope = undefined;
            this.$state = undefined;
            this.$translate = undefined;
            this.WriteQueries = undefined;
            this.progression = undefined;
            this.notification = undefined;
        }
    }]);

    return BatchDeleteController;
}();

exports.default = BatchDeleteController;


BatchDeleteController.$inject = ['$scope', '$state', '$translate', 'WriteQueries', 'progression', 'notification', 'view'];
module.exports = exports['default'];
//# sourceMappingURL=BatchDeleteController.js.map