'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var DeleteController = function () {
    function DeleteController($scope, $window, $state, $q, $translate, WriteQueries, Configuration, progression, notification, params, view, entry) {
        var _this = this;

        _classCallCheck(this, DeleteController);

        this.$scope = $scope;
        this.$window = $window;
        this.$state = $state;
        this.$translate = $translate;
        this.WriteQueries = WriteQueries;
        this.config = Configuration();
        this.entityLabel = params.entity;
        this.entityId = params.id;
        this.view = view;
        this.title = view.title();
        this.description = view.description();
        this.actions = view.actions();
        this.entity = view.getEntity();
        this.progression = progression;
        this.notification = notification;
        this.$scope.entry = entry;
        this.$scope.view = view;

        $scope.$on('$destroy', this.destroy.bind(this));

        this.previousStateParametersDeferred = $q.defer();
        $scope.$on('$stateChangeSuccess', function (event, to, toParams, from, fromParams) {
            _this.previousStateParametersDeferred.resolve(fromParams);
        });
    }

    _createClass(DeleteController, [{
        key: 'deleteOne',
        value: function deleteOne() {
            var _this2 = this;

            var entityName = this.entity.name();
            var $translate = this.$translate,
                notification = this.notification,
                progression = this.progression;

            progression.start();
            return this.WriteQueries.deleteOne(this.view, this.entityId).then(function () {
                return _this2.previousStateParametersDeferred.promise;
            }).then(function (previousStateParameters) {
                // if previous page was related to deleted entity, redirect to list
                if (previousStateParameters.entity === entityName && previousStateParameters.id === _this2.entityId) {
                    return _this2.$state.go(_this2.$state.get('list'), angular.extend({
                        entity: entityName
                    }, _this2.$state.params));
                }
                return _this2.back();
            })
            // no need to call progression.done() in case of success, as it's called by the view dislayed afterwards
            .then(function () {
                return $translate('DELETE_SUCCESS');
            }).then(function (text) {
                return notification.log(text, { addnCls: 'humane-flatty-success' });
            }).catch(function (error) {
                var errorMessage = _this2.config.getErrorMessageFor(_this2.view, error) || 'ERROR_MESSAGE';
                progression.done();
                $translate(errorMessage, {
                    status: error && error.status,
                    details: error && error.data && _typeof(error.data) === 'object' ? JSON.stringify(error.data) : {}
                }).catch(angular.identity) // See https://github.com/angular-translate/angular-translate/issues/1516
                .then(function (text) {
                    return notification.log(text, { addnCls: 'humane-flatty-error' });
                });
            });
        }
    }, {
        key: 'back',
        value: function back() {
            this.$window.history.back();
        }
    }, {
        key: 'destroy',
        value: function destroy() {
            this.$scope = undefined;
            this.$window = undefined;
            this.$state = undefined;
            this.$translate = undefined;
            this.WriteQueries = undefined;
            this.view = undefined;
            this.entity = undefined;
            this.progression = undefined;
            this.notification = undefined;
        }
    }]);

    return DeleteController;
}();

exports.default = DeleteController;


DeleteController.$inject = ['$scope', '$window', '$state', '$q', '$translate', 'WriteQueries', 'NgAdminConfiguration', 'progression', 'notification', 'params', 'view', 'entry'];
module.exports = exports['default'];
//# sourceMappingURL=DeleteController.js.map