'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = maDatagridInfinitePagination;

var _angular = require('angular');

var _angular2 = _interopRequireDefault(_angular);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var isScrollingDown = function isScrollingDown(wheelEvent) {
    if (!wheelEvent) return true;

    return wheelEvent.deltaY > 0;
};

function maDatagridInfinitePagination($window, $document) {
    var offset = 100;
    var body = $document[0].body;

    return {
        restrict: 'E',
        scope: {
            perPage: '@',
            totalItems: '@',
            nextPage: '&'
        },
        link: function link(scope) {
            scope.processing = false;
            var perPage = parseInt(scope.perPage, 10) || 1;
            var totalItems = parseInt(scope.totalItems, 10);
            var nbPages = Math.ceil(totalItems / perPage) || 1;
            var loadedPages = [];
            var page = 1;
            var interval = void 0;

            var handler = function handler(wheelEvent) {
                if (!isScrollingDown(wheelEvent) || scope.processing || !!interval) {
                    return;
                }

                scope.processing = true;

                interval = setInterval(function () {
                    if (body.offsetHeight - $window.innerHeight - $window.scrollY < offset) {
                        if (page >= nbPages) {
                            return;
                        }

                        page++;

                        if (page in loadedPages) {
                            return;
                        }

                        loadedPages.push(page);
                        scope.nextPage()(page);
                    } else {
                        scope.processing = false;

                        if (interval) {
                            clearInterval(interval);
                            interval = null;
                        }
                    }
                }, 100);
            };

            // Trigger the scroll at least once
            // This way, it loads at least one screen of data to enable further scrolling
            // @see https://github.com/marmelab/ng-admin/issues/681
            handler();

            $window.addEventListener('wheel', handler);
            scope.$on('$destroy', function () {
                $window.removeEventListener('wheel', handler);

                if (interval) {
                    clearInterval(interval);
                }
            });
        }
    };
}

maDatagridInfinitePagination.$inject = ['$window', '$document'];
module.exports = exports['default'];
//# sourceMappingURL=maDatagridInfinitePagination.js.map