'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/**
 * This file is generated. Don't modify it directly. (c)
 */
(function (root, factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(factory);
    } else if ((typeof exports === 'undefined' ? 'undefined' : _typeof(exports)) === 'object') {
        // Node.js
        module.exports = factory();
    } else {
        // Browser globals (root is window)
        root.ngaConfigurationFactory = factory();
    }
})(undefined, function () {
    /**
     * @license almond 0.3.1 Copyright (c) 2011-2014, The Dojo Foundation All Rights Reserved.
     * Available via the MIT or new BSD license.
     * see: http://github.com/jrburke/almond for details
     */
    //Going sloppy to avoid 'use strict' string cost, but strict practices should
    //be followed.
    /*jslint sloppy: true */
    /*global setTimeout: false */

    var requirejs, require, define;
    (function (undef) {
        var main,
            _req,
            makeMap,
            handlers,
            defined = {},
            waiting = {},
            config = {},
            defining = {},
            hasOwn = Object.prototype.hasOwnProperty,
            aps = [].slice,
            jsSuffixRegExp = /\.js$/;

        function hasProp(obj, prop) {
            return hasOwn.call(obj, prop);
        }

        /**
         * Given a relative module name, like ./something, normalize it to
         * a real name that can be mapped to a path.
         * @param {String} name the relative name
         * @param {String} baseName a real name that the name arg is relative
         * to.
         * @returns {String} normalized name
         */
        function normalize(name, baseName) {
            var nameParts,
                nameSegment,
                mapValue,
                foundMap,
                lastIndex,
                foundI,
                foundStarMap,
                starI,
                i,
                j,
                part,
                baseParts = baseName && baseName.split("/"),
                map = config.map,
                starMap = map && map['*'] || {};

            //Adjust any relative paths.
            if (name && name.charAt(0) === ".") {
                //If have a base name, try to normalize against it,
                //otherwise, assume it is a top-level require that will
                //be relative to baseUrl in the end.
                if (baseName) {
                    name = name.split('/');
                    lastIndex = name.length - 1;

                    // Node .js allowance:
                    if (config.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {
                        name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');
                    }

                    //Lop off the last part of baseParts, so that . matches the
                    //"directory" and not name of the baseName's module. For instance,
                    //baseName of "one/two/three", maps to "one/two/three.js", but we
                    //want the directory, "one/two" for this normalization.
                    name = baseParts.slice(0, baseParts.length - 1).concat(name);

                    //start trimDots
                    for (i = 0; i < name.length; i += 1) {
                        part = name[i];
                        if (part === ".") {
                            name.splice(i, 1);
                            i -= 1;
                        } else if (part === "..") {
                            if (i === 1 && (name[2] === '..' || name[0] === '..')) {
                                //End of the line. Keep at least one non-dot
                                //path segment at the front so it can be mapped
                                //correctly to disk. Otherwise, there is likely
                                //no path mapping for a path starting with '..'.
                                //This can still fail, but catches the most reasonable
                                //uses of ..
                                break;
                            } else if (i > 0) {
                                name.splice(i - 1, 2);
                                i -= 2;
                            }
                        }
                    }
                    //end trimDots

                    name = name.join("/");
                } else if (name.indexOf('./') === 0) {
                    // No baseName, so this is ID is resolved relative
                    // to baseUrl, pull off the leading dot.
                    name = name.substring(2);
                }
            }

            //Apply map config if available.
            if ((baseParts || starMap) && map) {
                nameParts = name.split('/');

                for (i = nameParts.length; i > 0; i -= 1) {
                    nameSegment = nameParts.slice(0, i).join("/");

                    if (baseParts) {
                        //Find the longest baseName segment match in the config.
                        //So, do joins on the biggest to smallest lengths of baseParts.
                        for (j = baseParts.length; j > 0; j -= 1) {
                            mapValue = map[baseParts.slice(0, j).join('/')];

                            //baseName segment has  config, find if it has one for
                            //this name.
                            if (mapValue) {
                                mapValue = mapValue[nameSegment];
                                if (mapValue) {
                                    //Match, update name to the new value.
                                    foundMap = mapValue;
                                    foundI = i;
                                    break;
                                }
                            }
                        }
                    }

                    if (foundMap) {
                        break;
                    }

                    //Check for a star map match, but just hold on to it,
                    //if there is a shorter segment match later in a matching
                    //config, then favor over this star map.
                    if (!foundStarMap && starMap && starMap[nameSegment]) {
                        foundStarMap = starMap[nameSegment];
                        starI = i;
                    }
                }

                if (!foundMap && foundStarMap) {
                    foundMap = foundStarMap;
                    foundI = starI;
                }

                if (foundMap) {
                    nameParts.splice(0, foundI, foundMap);
                    name = nameParts.join('/');
                }
            }

            return name;
        }

        function makeRequire(relName, forceSync) {
            return function () {
                //A version of a require function that passes a moduleName
                //value for items that may need to
                //look up paths relative to the moduleName
                var args = aps.call(arguments, 0);

                //If first arg is not require('string'), and there is only
                //one arg, it is the array form without a callback. Insert
                //a null so that the following concat is correct.
                if (typeof args[0] !== 'string' && args.length === 1) {
                    args.push(null);
                }
                return _req.apply(undef, args.concat([relName, forceSync]));
            };
        }

        function makeNormalize(relName) {
            return function (name) {
                return normalize(name, relName);
            };
        }

        function makeLoad(depName) {
            return function (value) {
                defined[depName] = value;
            };
        }

        function callDep(name) {
            if (hasProp(waiting, name)) {
                var args = waiting[name];
                delete waiting[name];
                defining[name] = true;
                main.apply(undef, args);
            }

            if (!hasProp(defined, name) && !hasProp(defining, name)) {
                throw new Error('No ' + name);
            }
            return defined[name];
        }

        //Turns a plugin!resource to [plugin, resource]
        //with the plugin being undefined if the name
        //did not have a plugin prefix.
        function splitPrefix(name) {
            var prefix,
                index = name ? name.indexOf('!') : -1;
            if (index > -1) {
                prefix = name.substring(0, index);
                name = name.substring(index + 1, name.length);
            }
            return [prefix, name];
        }

        /**
         * Makes a name map, normalizing the name, and using a plugin
         * for normalization if necessary. Grabs a ref to plugin
         * too, as an optimization.
         */
        makeMap = function makeMap(name, relName) {
            var plugin,
                parts = splitPrefix(name),
                prefix = parts[0];

            name = parts[1];

            if (prefix) {
                prefix = normalize(prefix, relName);
                plugin = callDep(prefix);
            }

            //Normalize according
            if (prefix) {
                if (plugin && plugin.normalize) {
                    name = plugin.normalize(name, makeNormalize(relName));
                } else {
                    name = normalize(name, relName);
                }
            } else {
                name = normalize(name, relName);
                parts = splitPrefix(name);
                prefix = parts[0];
                name = parts[1];
                if (prefix) {
                    plugin = callDep(prefix);
                }
            }

            //Using ridiculous property names for space reasons
            return {
                f: prefix ? prefix + '!' + name : name, //fullName
                n: name,
                pr: prefix,
                p: plugin
            };
        };

        function makeConfig(name) {
            return function () {
                return config && config.config && config.config[name] || {};
            };
        }

        handlers = {
            require: function require(name) {
                return makeRequire(name);
            },
            exports: function exports(name) {
                var e = defined[name];
                if (typeof e !== 'undefined') {
                    return e;
                } else {
                    return defined[name] = {};
                }
            },
            module: function module(name) {
                return {
                    id: name,
                    uri: '',
                    exports: defined[name],
                    config: makeConfig(name)
                };
            }
        };

        main = function main(name, deps, callback, relName) {
            var cjsModule,
                depName,
                ret,
                map,
                i,
                args = [],
                callbackType = typeof callback === 'undefined' ? 'undefined' : _typeof(callback),
                usingExports;

            //Use name if no relName
            relName = relName || name;

            //Call the callback to define the module, if necessary.
            if (callbackType === 'undefined' || callbackType === 'function') {
                //Pull out the defined dependencies and pass the ordered
                //values to the callback.
                //Default to [require, exports, module] if no deps
                deps = !deps.length && callback.length ? ['require', 'exports', 'module'] : deps;
                for (i = 0; i < deps.length; i += 1) {
                    map = makeMap(deps[i], relName);
                    depName = map.f;

                    //Fast path CommonJS standard dependencies.
                    if (depName === "require") {
                        args[i] = handlers.require(name);
                    } else if (depName === "exports") {
                        //CommonJS module spec 1.1
                        args[i] = handlers.exports(name);
                        usingExports = true;
                    } else if (depName === "module") {
                        //CommonJS module spec 1.1
                        cjsModule = args[i] = handlers.module(name);
                    } else if (hasProp(defined, depName) || hasProp(waiting, depName) || hasProp(defining, depName)) {
                        args[i] = callDep(depName);
                    } else if (map.p) {
                        map.p.load(map.n, makeRequire(relName, true), makeLoad(depName), {});
                        args[i] = defined[depName];
                    } else {
                        throw new Error(name + ' missing ' + depName);
                    }
                }

                ret = callback ? callback.apply(defined[name], args) : undefined;

                if (name) {
                    //If setting exports via "module" is in play,
                    //favor that over return value and exports. After that,
                    //favor a non-undefined return value over exports use.
                    if (cjsModule && cjsModule.exports !== undef && cjsModule.exports !== defined[name]) {
                        defined[name] = cjsModule.exports;
                    } else if (ret !== undef || !usingExports) {
                        //Use the return value from the function.
                        defined[name] = ret;
                    }
                }
            } else if (name) {
                //May just be an object definition for the module. Only
                //worry about defining if have a module name.
                defined[name] = callback;
            }
        };

        requirejs = require = _req = function req(deps, callback, relName, forceSync, alt) {
            if (typeof deps === "string") {
                if (handlers[deps]) {
                    //callback in this case is really relName
                    return handlers[deps](callback);
                }
                //Just return the module wanted. In this scenario, the
                //deps arg is the module name, and second arg (if passed)
                //is just the relName.
                //Normalize module name, if it contains . or ..
                return callDep(makeMap(deps, callback).f);
            } else if (!deps.splice) {
                //deps is a config object, not an array.
                config = deps;
                if (config.deps) {
                    _req(config.deps, config.callback);
                }
                if (!callback) {
                    return;
                }

                if (callback.splice) {
                    //callback is an array, which means it is a dependency list.
                    //Adjust args if there are dependencies
                    deps = callback;
                    callback = relName;
                    relName = null;
                } else {
                    deps = undef;
                }
            }

            //Support require(['a'])
            callback = callback || function () {};

            //If relName is a function, it is an errback handler,
            //so remove it.
            if (typeof relName === 'function') {
                relName = forceSync;
                forceSync = alt;
            }

            //Simulate async callback;
            if (forceSync) {
                main(undef, deps, callback, relName);
            } else {
                //Using a non-zero value because of concern for what old browsers
                //do, and latest browsers "upgrade" to 4 if lower value is used:
                //http://www.whatwg.org/specs/web-apps/current-work/multipage/timers.html#dom-windowtimers-settimeout:
                //If want a value immediately, use require('id') instead -- something
                //that works in almond on the global level, but not guaranteed and
                //unlikely to work in other AMD implementations.
                setTimeout(function () {
                    main(undef, deps, callback, relName);
                }, 4);
            }

            return _req;
        };

        /**
         * Just drops the config on the floor, but returns req in case
         * the config return value is used.
         */
        _req.config = function (cfg) {
            return _req(cfg);
        };

        /**
         * Expose module registry for debugging and tooling
         */
        requirejs._defined = defined;

        define = function define(name, deps, callback) {
            if (typeof name !== 'string') {
                throw new Error('See almond README: incorrect module build, no module name');
            }

            //This module may not have dependencies
            if (!deps.splice) {
                //deps is not an array, so probably means
                //an object literal or factory function for
                //the value. Adjust args.
                callback = deps;
                deps = [];
            }

            if (!hasProp(defined, name) && !hasProp(waiting, name)) {
                waiting[name] = [name, deps, callback];
            }
        };

        define.amd = {
            jQuery: true
        };
    })();

    define("../../src/javascripts/bower_components/almond/almond", function () {});

    define('Utils/stringUtils', ["exports", "module"], function (exports, module) {
        "use strict";

        module.exports = {
            /**
             * @see http://stackoverflow.com/questions/10425287/convert-string-to-camelcase-with-regular-expression
             * @see http://phpjs.org/functions/ucfirst/
             */
            camelCase: function camelCase(text) {
                if (!text) {
                    return text;
                }

                var f = text.charAt(0).toUpperCase();
                text = f + text.substr(1);

                return text.replace(/[-_](.)/g, function (match, group1) {
                    return " " + group1.toUpperCase();
                });
            }
        };
    });
    //# sourceMappingURL=stringUtils.js.map;
    define('Field/Field', ["exports", "module", "../Utils/stringUtils"], function (exports, module, _UtilsStringUtils) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var stringUtils = _interopRequire(_UtilsStringUtils);

        var Field = function () {
            function Field(name) {
                _classCallCheck(this, Field);

                this._name = name || Math.random().toString(36).substring(7);
                this._detailLink = name === "id";
                this._type = "string";
                this._order = null;
                this._label = null;
                this._maps = [];
                this._attributes = {};
                this._cssClasses = null;
                this._validation = { required: false, minlength: 0, maxlength: 99999 };
                this._defaultValue = null;
                this._editable = true;
                this._detailLinkRoute = "edit";
                this.dashboard = true;
                this.list = true;
            }

            _createClass(Field, {
                label: {
                    value: function label() {
                        if (arguments.length) {
                            this._label = arguments[0];
                            return this;
                        }

                        if (this._label === null) {
                            return stringUtils.camelCase(this._name);
                        }

                        return this._label;
                    }
                },
                type: {
                    value: function type() {
                        return this._type;
                    }
                },
                name: {
                    value: function name() {
                        if (arguments.length) {
                            this._name = arguments[0];
                            return this;
                        }

                        return this._name;
                    }
                },
                order: {
                    value: function order() {
                        if (arguments.length) {
                            if (arguments[1] !== true) {
                                console.warn("Setting order with Field.order is deprecated, order directly in fields array");
                            }
                            this._order = arguments[0];
                            return this;
                        }

                        return this._order;
                    }
                },
                isDetailLink: {
                    value: function isDetailLink(detailLink) {
                        if (arguments.length) {
                            this._detailLink = arguments[0];
                            return this;
                        }

                        if (this._detailLink === null) {
                            return this._name === "id";
                        }

                        return this._detailLink;
                    }
                },
                detailLink: {
                    set: function set(isDetailLink) {
                        return this._detailLink = isDetailLink;
                    }
                },
                map: {
                    value: function map(fn) {
                        if (!fn) {
                            return this._maps;
                        }if (typeof fn !== "function") {
                            var type = typeof fn === 'undefined' ? 'undefined' : _typeof(fn);
                            throw new Error("Map argument should be a function, " + type + " given.");
                        }

                        this._maps.push(fn);

                        return this;
                    }
                },
                hasMaps: {
                    value: function hasMaps() {
                        return !!this._maps.length;
                    }
                },
                attributes: {
                    value: function (_attributes) {
                        var _attributesWrapper = function attributes(_x) {
                            return _attributes.apply(this, arguments);
                        };

                        _attributesWrapper.toString = function () {
                            return _attributes.toString();
                        };

                        return _attributesWrapper;
                    }(function (attributes) {
                        if (!arguments.length) {
                            return this._attributes;
                        }

                        this._attributes = attributes;

                        return this;
                    })
                },
                cssClasses: {
                    value: function cssClasses(classes) {
                        if (!arguments.length) {
                            return this._cssClasses;
                        }this._cssClasses = classes;
                        return this;
                    }
                },
                getCssClasses: {
                    value: function getCssClasses(entry) {
                        if (!this._cssClasses) {
                            return "";
                        }

                        if (this._cssClasses.constructor === Array) {
                            return this._cssClasses.join(" ");
                        }

                        if (typeof this._cssClasses === "function") {
                            return this._cssClasses(entry);
                        }

                        return this._cssClasses;
                    }
                },
                getMappedValue: {
                    value: function getMappedValue(value, entry) {
                        for (var i in this._maps) {
                            value = this._maps[i](value, entry);
                        }

                        return value;
                    }
                },
                validation: {
                    value: function (_validation) {
                        var _validationWrapper = function validation(_x2) {
                            return _validation.apply(this, arguments);
                        };

                        _validationWrapper.toString = function () {
                            return _validation.toString();
                        };

                        return _validationWrapper;
                    }(function (validation) {
                        if (!arguments.length) {
                            return this._validation;
                        }

                        for (var property in validation) {
                            if (!validation.hasOwnProperty(property)) continue;
                            if (validation[property] === null) {
                                delete this._validation[property];
                            } else {
                                this._validation[property] = validation[property];
                            }
                        }

                        return this;
                    })
                },
                defaultValue: {
                    value: function (_defaultValue) {
                        var _defaultValueWrapper = function defaultValue(_x3) {
                            return _defaultValue.apply(this, arguments);
                        };

                        _defaultValueWrapper.toString = function () {
                            return _defaultValue.toString();
                        };

                        return _defaultValueWrapper;
                    }(function (defaultValue) {
                        if (!arguments.length) return this._defaultValue;
                        this._defaultValue = defaultValue;
                        return this;
                    })
                },
                editable: {
                    value: function (_editable) {
                        var _editableWrapper = function editable(_x4) {
                            return _editable.apply(this, arguments);
                        };

                        _editableWrapper.toString = function () {
                            return _editable.toString();
                        };

                        return _editableWrapper;
                    }(function (editable) {
                        if (!arguments.length) return this._editable;
                        this._editable = editable;
                        return this;
                    })
                },
                detailLinkRoute: {
                    value: function detailLinkRoute(route) {
                        if (!arguments.length) {
                            return this._detailLinkRoute;
                        }this._detailLinkRoute = route;
                        return this;
                    }
                }
            });

            return Field;
        }();

        module.exports = Field;
    });
    //# sourceMappingURL=Field.js.map;
    define('Entry', ["exports", "module"], function (exports, module) {
        "use strict";

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Entry = function () {
            function Entry(entityName, values, identifierValue) {
                _classCallCheck(this, Entry);

                this._entityName = entityName;
                this.values = values || {};
                this._identifierValue = identifierValue;
                this.listValues = {};
            }

            _createClass(Entry, {
                entityName: {
                    get: function get() {
                        return this._entityName;
                    }
                },
                identifierValue: {
                    get: function get() {
                        return this._identifierValue;
                    }
                }
            }, {
                mapFromRest: {
                    value: function mapFromRest(entityName, identifier, fields, restEntry) {
                        if (!restEntry) {
                            return new Entry(entityName);
                        }

                        var identifierValue = null;

                        fields.forEach(function (field) {
                            var fieldName = field.name();
                            if (fieldName in restEntry) {
                                restEntry[fieldName] = field.getMappedValue(restEntry[fieldName], restEntry);
                            }
                        });

                        // Add identifier value
                        if (identifier) {
                            identifierValue = restEntry[identifier.name()];
                        }

                        return new Entry(entityName, restEntry, identifierValue);
                    }
                }
            });

            return Entry;
        }();

        module.exports = Entry;
    });
    //# sourceMappingURL=Entry.js.map;
    define('View/View', ["exports", "module", "../Entry"], function (exports, module, _Entry) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Entry = _interopRequire(_Entry);

        var View = function () {
            function View(name) {
                _classCallCheck(this, View);

                this.entity = null;
                this._actions = null;
                this._title = false;
                this._description = "";
                this._template = null;

                this._enabled = true;
                this._fields = [];
                this._type = null;
                this._name = name;
                this._order = 0;
                this._errorMessage = null;
                this._url = null;
            }

            _createClass(View, {
                enabled: {
                    get: function get() {
                        return this._enabled;
                    }
                },
                title: {
                    value: function (_title) {
                        var _titleWrapper = function title(_x) {
                            return _title.apply(this, arguments);
                        };

                        _titleWrapper.toString = function () {
                            return _title.toString();
                        };

                        return _titleWrapper;
                    }(function (title) {
                        if (!arguments.length) return this._title;
                        this._title = title;
                        return this;
                    })
                },
                description: {
                    value: function description() {
                        if (arguments.length) {
                            this._description = arguments[0];
                            return this;
                        }

                        return this._description;
                    }
                },
                name: {
                    value: function (_name) {
                        var _nameWrapper = function name(_x2) {
                            return _name.apply(this, arguments);
                        };

                        _nameWrapper.toString = function () {
                            return _name.toString();
                        };

                        return _nameWrapper;
                    }(function (name) {
                        if (!arguments.length) {
                            return this._name || this.entity.name() + "_" + this._type;
                        }

                        this._name = name;
                        return this;
                    })
                },
                disable: {
                    value: function disable() {
                        this._enabled = false;
                    }
                },
                enable: {
                    value: function enable() {
                        this._enabled = true;
                    }
                },
                isEnabled: {

                    /**
                     * @deprecated Use getter "enabled" instead
                     */

                    value: function isEnabled() {
                        return this._enabled;
                    }
                },
                getEntity: {

                    /**
                     * @deprecated Use getter "entity" instead
                     */

                    value: function getEntity() {
                        return this.entity;
                    }
                },
                setEntity: {

                    /**
                     * @deprecated Specify entity at view creation or use "entity" setter instead
                     */

                    value: function setEntity(entity) {
                        this.entity = entity;
                        if (!this._name) {
                            this._name = entity.name() + "_" + this._type;
                        }

                        return this;
                    }
                },
                fields: {

                    /*
                     * Supports various syntax
                     * fields([ Field1, Field2 ])
                     * fields(Field1, Field2)
                     * fields([Field1, {Field2, Field3}])
                     * fields(Field1, {Field2, Field3})
                     * fields({Field2, Field3})
                     */

                    value: function fields() {
                        if (!arguments.length) {
                            return this._fields;
                        }[].slice.call(arguments).map(function (argument) {
                            var _this = this;

                            View.flatten(argument).map(function (arg) {
                                return _this.addField(arg);
                            });
                        }, this);

                        return this;
                    }
                },
                type: {
                    get: function get() {
                        return this._type;
                    }
                },
                order: {
                    value: function (_order) {
                        var _orderWrapper = function order(_x3) {
                            return _order.apply(this, arguments);
                        };

                        _orderWrapper.toString = function () {
                            return _order.toString();
                        };

                        return _orderWrapper;
                    }(function (order) {
                        if (!arguments.length) return this._order;
                        this._order = order;
                        return this;
                    })
                },
                getReferences: {
                    value: function getReferences() {
                        var result = {};
                        var lists = this._fields.filter(function (f) {
                            return f.type() === "reference" || f.type() === "reference_many";
                        });
                        for (var i = 0, c = lists.length; i < c; i++) {
                            var list = lists[i];
                            result[list.name()] = list;
                        }

                        return result;
                    }
                },
                getReferencedLists: {
                    value: function getReferencedLists() {
                        var result = {};
                        var lists = this._fields.filter(function (f) {
                            return f.type() === "referenced_list";
                        });
                        for (var i = 0, c = lists.length; i < c; i++) {
                            var list = lists[i];
                            result[list.name()] = list;
                        }

                        return result;
                    }
                },
                template: {
                    value: function (_template) {
                        var _templateWrapper = function template(_x4) {
                            return _template.apply(this, arguments);
                        };

                        _templateWrapper.toString = function () {
                            return _template.toString();
                        };

                        return _templateWrapper;
                    }(function (template) {
                        if (!arguments.length) {
                            return this._template;
                        }

                        this._template = template;

                        return this;
                    })
                },
                identifier: {
                    value: function identifier() {
                        return this.entity.identifier();
                    }
                },
                actions: {
                    value: function (_actions) {
                        var _actionsWrapper = function actions(_x5) {
                            return _actions.apply(this, arguments);
                        };

                        _actionsWrapper.toString = function () {
                            return _actions.toString();
                        };

                        return _actionsWrapper;
                    }(function (actions) {
                        if (!arguments.length) return this._actions;
                        this._actions = actions;
                        return this;
                    })
                },
                removeFields: {
                    value: function removeFields() {
                        this._fields = [];
                        return this;
                    }
                },
                getFields: {
                    value: function getFields() {
                        return this._fields;
                    }
                },
                getField: {
                    value: function getField(fieldName) {
                        return this._fields.filter(function (f) {
                            return f.name() === fieldName;
                        })[0];
                    }
                },
                getFieldsOfType: {
                    value: function getFieldsOfType(type) {
                        return this._fields.filter(function (f) {
                            return f.type() === type;
                        });
                    }
                },
                addField: {
                    value: function addField(field) {
                        if (field.order() === null) {
                            field.order(this._fields.length, true);
                        }
                        this._fields.push(field);
                        this._fields = this._fields.sort(function (a, b) {
                            return a.order() - b.order();
                        });

                        return this;
                    }
                },
                getErrorMessage: {
                    value: function getErrorMessage(response) {
                        if (typeof this._errorMessage === "function") {
                            return this._errorMessage(response);
                        }

                        return this._errorMessage;
                    }
                },
                errorMessage: {
                    value: function (_errorMessage) {
                        var _errorMessageWrapper = function errorMessage(_x6) {
                            return _errorMessage.apply(this, arguments);
                        };

                        _errorMessageWrapper.toString = function () {
                            return _errorMessage.toString();
                        };

                        return _errorMessageWrapper;
                    }(function (errorMessage) {
                        if (!arguments.length) return this._errorMessage;
                        this._errorMessage = errorMessage;
                        return this;
                    })
                },
                url: {
                    value: function (_url) {
                        var _urlWrapper = function url(_x7) {
                            return _url.apply(this, arguments);
                        };

                        _urlWrapper.toString = function () {
                            return _url.toString();
                        };

                        return _urlWrapper;
                    }(function (url) {
                        if (!arguments.length) return this._url;
                        this._url = url;
                        return this;
                    })
                },
                getUrl: {
                    value: function getUrl(identifierValue) {
                        if (typeof this._url === "function") {
                            return this._url(identifierValue);
                        }

                        return this._url;
                    }
                },
                validate: {
                    value: function validate(entry) {
                        this._fields.map(function (field) {
                            var validation = field.validation();
                            if (typeof validation.validator === "function") {
                                validation.validator(entry.values[field.name()]);
                            }
                        });
                    }
                }
            }, {
                flatten: {
                    value: function flatten(arg) {
                        if (arg.constructor.name === "Object") {
                            console.warn("Passing literal of Field to fields method is deprecated use array instead");
                            var result = [];
                            for (var fieldName in arg) {
                                result = result.concat(View.flatten(arg[fieldName]));
                            }
                            return result;
                        }
                        if (Array.isArray(arg)) {
                            return arg.reduce(function (previous, current) {
                                return previous.concat(View.flatten(current));
                            }, []);
                        }
                        // arg is a scalar
                        return [arg];
                    }
                }
            });

            return View;
        }();

        module.exports = View;
    });
    //# sourceMappingURL=View.js.map;
    define('View/ListView', ["exports", "module", "./View"], function (exports, module, _View2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var View = _interopRequire(_View2);

        var ListView = function (_View) {
            function ListView(name) {
                _classCallCheck(this, ListView);

                _get(Object.getPrototypeOf(ListView.prototype), "constructor", this).call(this, name);

                this._type = "ListView";
                this._perPage = 30;
                this._infinitePagination = false;
                this._listActions = [];
                this._batchActions = ["delete"];
                this._filters = [];
                this._exportFields = null;

                this._sortField = "id";
                this._sortDir = "DESC";
            }

            _inherits(ListView, _View);

            _createClass(ListView, {
                perPage: {
                    value: function perPage() {
                        if (!arguments.length) {
                            return this._perPage;
                        }
                        this._perPage = arguments[0];
                        return this;
                    }
                },
                limit: {

                    /** @deprecated Use perPage instead */

                    value: function limit() {
                        if (!arguments.length) {
                            return this.perPage();
                        }
                        return this.perPage(arguments[0]);
                    }
                },
                sortField: {
                    value: function sortField() {
                        if (arguments.length) {
                            this._sortField = arguments[0];
                            return this;
                        }

                        return this._sortField;
                    }
                },
                sortDir: {
                    value: function sortDir() {
                        if (arguments.length) {
                            this._sortDir = arguments[0];
                            return this;
                        }

                        return this._sortDir;
                    }
                },
                getSortFieldName: {
                    value: function getSortFieldName() {
                        return this.name() + "." + this._sortField;
                    }
                },
                infinitePagination: {
                    value: function infinitePagination() {
                        if (arguments.length) {
                            this._infinitePagination = arguments[0];
                            return this;
                        }

                        return this._infinitePagination;
                    }
                },
                actions: {
                    value: function (_actions) {
                        var _actionsWrapper = function actions(_x) {
                            return _actions.apply(this, arguments);
                        };

                        _actionsWrapper.toString = function () {
                            return _actions.toString();
                        };

                        return _actionsWrapper;
                    }(function (actions) {
                        if (!arguments.length) {
                            return this._actions;
                        }

                        this._actions = actions;

                        return this;
                    })
                },
                exportFields: {
                    value: function (_exportFields) {
                        var _exportFieldsWrapper = function exportFields(_x2) {
                            return _exportFields.apply(this, arguments);
                        };

                        _exportFieldsWrapper.toString = function () {
                            return _exportFields.toString();
                        };

                        return _exportFieldsWrapper;
                    }(function (exportFields) {
                        if (!arguments.length) {
                            return this._exportFields;
                        }

                        this._exportFields = exportFields;

                        return this;
                    })
                },
                batchActions: {
                    value: function batchActions(actions) {
                        if (!arguments.length) {
                            return this._batchActions;
                        }

                        this._batchActions = actions;

                        return this;
                    }
                },
                filters: {
                    value: function (_filters) {
                        var _filtersWrapper = function filters(_x3) {
                            return _filters.apply(this, arguments);
                        };

                        _filtersWrapper.toString = function () {
                            return _filters.toString();
                        };

                        return _filtersWrapper;
                    }(function (filters) {
                        if (!arguments.length) {
                            return this._filters;
                        }

                        this._filters = filters;

                        return this;
                    })
                },
                getFilterReferences: {
                    value: function getFilterReferences() {
                        var result = {};
                        var lists = this._fields.filter(function (f) {
                            return f.type() === "reference";
                        });
                        for (var i = 0, c = lists.length; i < c; i++) {
                            var list = lists[i];
                            result[list.name()] = list;
                        }

                        return result;
                    }
                },
                listActions: {
                    value: function listActions(actions) {
                        if (!arguments.length) {
                            return this._listActions;
                        }

                        this._listActions = actions;

                        return this;
                    }
                }
            });

            return ListView;
        }(View);

        module.exports = ListView;
    });
    //# sourceMappingURL=ListView.js.map;
    define('View/DashboardView', ["exports", "module", "./ListView"], function (exports, module, _ListView2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var ListView = _interopRequire(_ListView2);

        var DashboardView = function (_ListView) {
            function DashboardView(name) {
                _classCallCheck(this, DashboardView);

                _get(Object.getPrototypeOf(DashboardView.prototype), "constructor", this).call(this, name);
                this._type = "DashboardView";
            }

            _inherits(DashboardView, _ListView);

            return DashboardView;
        }(ListView);

        module.exports = DashboardView;
    });
    //# sourceMappingURL=DashboardView.js.map;
    define('View/MenuView', ["exports", "module", "./View"], function (exports, module, _View2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var View = _interopRequire(_View2);

        var MenuView = function (_View) {
            function MenuView(name) {
                _classCallCheck(this, MenuView);

                _get(Object.getPrototypeOf(MenuView.prototype), "constructor", this).call(this, name);
                this._type = "MenuView";
                this._icon = null;
            }

            _inherits(MenuView, _View);

            _createClass(MenuView, {
                icon: {
                    value: function icon() {
                        if (arguments.length) {
                            console.warn("entity.menuView() is deprecated. Please use the Menu class instead");
                            this._icon = arguments[0];
                            return this;
                        }

                        if (this._icon === null) {
                            return "<span class=\"glyphicon glyphicon-list\"></span>";
                        }

                        return this._icon;
                    }
                }
            });

            return MenuView;
        }(View);

        module.exports = MenuView;
    });
    //# sourceMappingURL=MenuView.js.map;
    define('View/CreateView', ["exports", "module", "./View"], function (exports, module, _View2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var View = _interopRequire(_View2);

        var CreateView = function (_View) {
            function CreateView(name) {
                _classCallCheck(this, CreateView);

                _get(Object.getPrototypeOf(CreateView.prototype), "constructor", this).call(this, name);
                this._type = "CreateView";
            }

            _inherits(CreateView, _View);

            return CreateView;
        }(View);

        module.exports = CreateView;
    });
    //# sourceMappingURL=CreateView.js.map;
    define('View/EditView', ["exports", "module", "./View"], function (exports, module, _View2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var View = _interopRequire(_View2);

        var EditView = function (_View) {
            function EditView(name) {
                _classCallCheck(this, EditView);

                _get(Object.getPrototypeOf(EditView.prototype), "constructor", this).call(this, name);
                this._type = "EditView";
            }

            _inherits(EditView, _View);

            return EditView;
        }(View);

        module.exports = EditView;
    });
    //# sourceMappingURL=EditView.js.map;
    define('View/DeleteView', ["exports", "module", "./View"], function (exports, module, _View2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var View = _interopRequire(_View2);

        var DeleteView = function (_View) {
            function DeleteView(name) {
                _classCallCheck(this, DeleteView);

                _get(Object.getPrototypeOf(DeleteView.prototype), "constructor", this).call(this, name);
                this._type = "DeleteView";
            }

            _inherits(DeleteView, _View);

            return DeleteView;
        }(View);

        module.exports = DeleteView;
    });
    //# sourceMappingURL=DeleteView.js.map;
    define('View/ShowView', ["exports", "module", "./View"], function (exports, module, _View2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var View = _interopRequire(_View2);

        var ShowView = function (_View) {
            function ShowView(name) {
                _classCallCheck(this, ShowView);

                _get(Object.getPrototypeOf(ShowView.prototype), "constructor", this).call(this, name);
                this._type = "ShowView";
            }

            _inherits(ShowView, _View);

            return ShowView;
        }(View);

        module.exports = ShowView;
    });
    //# sourceMappingURL=ShowView.js.map;
    define('View/BatchDeleteView', ["exports", "module", "./View"], function (exports, module, _View2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var View = _interopRequire(_View2);

        var BatchDeleteView = function (_View) {
            function BatchDeleteView(name) {
                _classCallCheck(this, BatchDeleteView);

                _get(Object.getPrototypeOf(BatchDeleteView.prototype), "constructor", this).call(this, name);

                this._type = "BatchDeleteView";
            }

            _inherits(BatchDeleteView, _View);

            return BatchDeleteView;
        }(View);

        module.exports = BatchDeleteView;
    });
    //# sourceMappingURL=BatchDeleteView.js.map;
    define('View/ExportView', ["exports", "module", "./ListView"], function (exports, module, _ListView2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var ListView = _interopRequire(_ListView2);

        var ExportView = function (_ListView) {
            function ExportView(name) {
                _classCallCheck(this, ExportView);

                _get(Object.getPrototypeOf(ExportView.prototype), "constructor", this).call(this, name);
                this._fields = [];
                this._type = "ExportView";
            }

            _inherits(ExportView, _ListView);

            return ExportView;
        }(ListView);

        module.exports = ExportView;
    });
    //# sourceMappingURL=ExportView.js.map;
    define('Entity/Entity', ["exports", "module", "../Utils/stringUtils", "../Field/Field", "../View/DashboardView", "../View/MenuView", "../View/ListView", "../View/CreateView", "../View/EditView", "../View/DeleteView", "../View/ShowView", "../View/BatchDeleteView", "../View/ExportView"], function (exports, module, _UtilsStringUtils, _FieldField, _ViewDashboardView, _ViewMenuView, _ViewListView, _ViewCreateView, _ViewEditView, _ViewDeleteView, _ViewShowView, _ViewBatchDeleteView, _ViewExportView) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var stringUtils = _interopRequire(_UtilsStringUtils);

        var Field = _interopRequire(_FieldField);

        var DashboardView = _interopRequire(_ViewDashboardView);

        var MenuView = _interopRequire(_ViewMenuView);

        var ListView = _interopRequire(_ViewListView);

        var CreateView = _interopRequire(_ViewCreateView);

        var EditView = _interopRequire(_ViewEditView);

        var DeleteView = _interopRequire(_ViewDeleteView);

        var ShowView = _interopRequire(_ViewShowView);

        var BatchDeleteView = _interopRequire(_ViewBatchDeleteView);

        var ExportView = _interopRequire(_ViewExportView);

        var index = 0;

        var Entity = function () {
            function Entity(name) {
                _classCallCheck(this, Entity);

                this._name = name;
                this._uniqueId = this._name + "_" + index++;
                this._baseApiUrl = null;
                this._label = null;
                this._identifierField = new Field("id");
                this._isReadOnly = false;
                this._errorMessage = null;
                this._order = 0;
                this._url = null;

                this._initViews();
            }

            _createClass(Entity, {
                uniqueId: {
                    get: function get() {
                        return this._uniqueId;
                    }
                },
                views: {
                    get: function get() {
                        return this._views;
                    }
                },
                label: {
                    value: function label() {
                        if (arguments.length) {
                            this._label = arguments[0];
                            return this;
                        }

                        if (this._label === null) {
                            return stringUtils.camelCase(this._name);
                        }

                        return this._label;
                    }
                },
                name: {
                    value: function name() {
                        if (arguments.length) {
                            this._name = arguments[0];
                            return this;
                        }

                        return this._name;
                    }
                },
                menuView: {

                    /**
                     * @deprecated Use .views["MenuView"] instead
                     */

                    value: function menuView() {
                        return this._views.MenuView;
                    }
                },
                dashboardView: {

                    /**
                     * @deprecated Use .views["DashboardView"] instead
                     */

                    value: function dashboardView() {
                        return this._views.DashboardView;
                    }
                },
                listView: {

                    /**
                     * @deprecated Use .views["ListView"] instead
                     */

                    value: function listView() {
                        return this._views.ListView;
                    }
                },
                creationView: {

                    /**
                     * @deprecated Use .views["CreateView"] instead
                     */

                    value: function creationView() {
                        return this._views.CreateView;
                    }
                },
                editionView: {

                    /**
                     * @deprecated Use .views["EditView"] instead
                     */

                    value: function editionView() {
                        return this._views.EditView;
                    }
                },
                deletionView: {

                    /**
                     * @deprecated Use .views["DeleteView"] instead
                     */

                    value: function deletionView() {
                        return this._views.DeleteView;
                    }
                },
                batchDeleteView: {

                    /**
                     * @deprecated Use .views["BatchDeleteView"] instead
                     */

                    value: function batchDeleteView() {
                        return this._views.BatchDeleteView;
                    }
                },
                exportView: {

                    /**
                     * @deprecated Use .views["ExportView"] instead
                     */

                    value: function exportView() {
                        return this._views.ExportView;
                    }
                },
                showView: {

                    /**
                     * @deprecated Use .views["ShowView"] instead
                     */

                    value: function showView() {
                        return this._views.ShowView;
                    }
                },
                baseApiUrl: {
                    value: function (_baseApiUrl) {
                        var _baseApiUrlWrapper = function baseApiUrl(_x) {
                            return _baseApiUrl.apply(this, arguments);
                        };

                        _baseApiUrlWrapper.toString = function () {
                            return _baseApiUrl.toString();
                        };

                        return _baseApiUrlWrapper;
                    }(function (baseApiUrl) {
                        if (!arguments.length) return this._baseApiUrl;
                        this._baseApiUrl = baseApiUrl;
                        return this;
                    })
                },
                _initViews: {
                    value: function _initViews() {
                        this._views = {
                            DashboardView: new DashboardView().setEntity(this),
                            MenuView: new MenuView().setEntity(this),
                            ListView: new ListView().setEntity(this),
                            CreateView: new CreateView().setEntity(this),
                            EditView: new EditView().setEntity(this),
                            DeleteView: new DeleteView().setEntity(this),
                            BatchDeleteView: new BatchDeleteView().setEntity(this),
                            ExportView: new ExportView().setEntity(this),
                            ShowView: new ShowView().setEntity(this)
                        };
                    }
                },
                identifier: {
                    value: function identifier(value) {
                        if (!arguments.length) {
                            return this._identifierField;
                        }this._identifierField = value;
                        return this;
                    }
                },
                readOnly: {
                    value: function readOnly() {
                        this._isReadOnly = true;

                        this._views.CreateView.disable();
                        this._views.EditView.disable();
                        this._views.DeleteView.disable();
                        this._views.BatchDeleteView.disable();

                        return this;
                    }
                },
                isReadOnly: {
                    get: function get() {
                        return this._isReadOnly;
                    }
                },
                getErrorMessage: {
                    value: function getErrorMessage(response) {
                        if (typeof this._errorMessage === "function") {
                            return this._errorMessage(response);
                        }

                        return this._errorMessage;
                    }
                },
                errorMessage: {
                    value: function (_errorMessage) {
                        var _errorMessageWrapper = function errorMessage(_x2) {
                            return _errorMessage.apply(this, arguments);
                        };

                        _errorMessageWrapper.toString = function () {
                            return _errorMessage.toString();
                        };

                        return _errorMessageWrapper;
                    }(function (errorMessage) {
                        if (!arguments.length) return this._errorMessage;
                        this._errorMessage = errorMessage;
                        return this;
                    })
                },
                order: {
                    value: function (_order) {
                        var _orderWrapper = function order(_x3) {
                            return _order.apply(this, arguments);
                        };

                        _orderWrapper.toString = function () {
                            return _order.toString();
                        };

                        return _orderWrapper;
                    }(function (order) {
                        if (!arguments.length) return this._order;
                        this._order = order;
                        return this;
                    })
                },
                url: {
                    value: function (_url) {
                        var _urlWrapper = function url(_x4) {
                            return _url.apply(this, arguments);
                        };

                        _urlWrapper.toString = function () {
                            return _url.toString();
                        };

                        return _urlWrapper;
                    }(function (url) {
                        if (!arguments.length) return this._url;
                        this._url = url;
                        return this;
                    })
                },
                getUrl: {
                    value: function getUrl(viewType, identifierValue, identifierName) {
                        if (typeof this._url === "function") {
                            return this._url(this.name(), viewType, identifierValue, identifierName);
                        }

                        return this._url;
                    }
                }
            });

            return Entity;
        }();

        module.exports = Entity;
    });
    //# sourceMappingURL=Entity.js.map;
    define('Menu/Menu', ["exports", "module", "../Entity/Entity"], function (exports, module, _EntityEntity) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Entity = _interopRequire(_EntityEntity);

        function alwaysFalse() {
            return false;
        }

        var uuid = 0;

        var Menu = function () {
            function Menu() {
                _classCallCheck(this, Menu);

                this._link = null;
                this._activeFunc = alwaysFalse;
                this._title = null;
                this._icon = false;
                this._children = [];
                this._template = false;
                this.uuid = uuid++;
            }

            _createClass(Menu, {
                title: {
                    value: function title() {
                        if (arguments.length) {
                            this._title = arguments[0];
                            return this;
                        }
                        return this._title;
                    }
                },
                isLink: {
                    value: function isLink() {
                        return !!this._link;
                    }
                },
                link: {
                    value: function link() {
                        var _this = this;

                        if (arguments.length) {
                            this._link = arguments[0];
                            if (this._activeFunc == alwaysFalse) {
                                this._activeFunc = function (url) {
                                    return url.indexOf(_this._link) === 0;
                                };
                            }
                            return this;
                        }
                        return this._link;
                    }
                },
                active: {
                    value: function active(activeFunc) {
                        if (arguments.length) {
                            this._activeFunc = arguments[0];
                            return this;
                        }
                        return this._activeFunc;
                    }
                },
                isActive: {
                    value: function isActive(url) {
                        return this._activeFunc(url);
                    }
                },
                isChildActive: {
                    value: function isChildActive(url) {
                        return this.isActive(url) || this.children().filter(function (menu) {
                            return menu.isChildActive(url);
                        }).length > 0;
                    }
                },
                addChild: {
                    value: function addChild(child) {
                        if (!(child instanceof Menu)) {
                            throw new Error("Only Menu instances are accepted as children of a Menu");
                        }
                        this._children.push(child);
                        return this;
                    }
                },
                hasChild: {
                    value: function hasChild() {
                        return this._children.length > 0;
                    }
                },
                getChildByTitle: {
                    value: function getChildByTitle(title) {
                        return this.children().filter(function (child) {
                            return child.title() == title;
                        }).pop();
                    }
                },
                children: {
                    value: function children() {
                        if (arguments.length) {
                            this._children = arguments[0];
                            return this;
                        }
                        return this._children;
                    }
                },
                icon: {
                    value: function icon() {
                        if (arguments.length) {
                            this._icon = arguments[0];
                            return this;
                        }
                        return this._icon;
                    }
                },
                template: {
                    value: function template() {
                        if (arguments.length) {
                            this._template = arguments[0];
                            return this;
                        }
                        return this._template;
                    }
                },
                populateFromEntity: {
                    value: function populateFromEntity(entity) {
                        if (!(entity instanceof Entity)) {
                            throw new Error("populateFromEntity() only accepts an Entity parameter");
                        }
                        this.title(entity.label());
                        this.active(function (path) {
                            return path.indexOf("/" + entity.name() + "/") === 0;
                        });
                        this.link("/" + entity.name() + "/list");
                        // deprecated
                        this.icon(entity.menuView().icon());
                        return this;
                    }
                }
            });

            return Menu;
        }();

        module.exports = Menu;
    });
    //# sourceMappingURL=Menu.js.map;
    define('Application', ["exports", "module", "./Menu/Menu"], function (exports, module, _MenuMenu) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Menu = _interopRequire(_MenuMenu);

        var Application = function () {
            function Application() {
                var title = arguments[0] === undefined ? "ng-admin" : arguments[0];
                var debug = arguments[1] === undefined ? true : arguments[1];

                _classCallCheck(this, Application);

                this._baseApiUrl = "";
                this._customTemplate = function (viewName) {};
                this._title = title;
                this._menu = null;
                this._layout = false;
                this._header = false;
                this._entities = [];
                this._errorMessage = this.defaultErrorMessage;
                this._debug = debug;
            }

            _createClass(Application, {
                defaultErrorMessage: {
                    value: function defaultErrorMessage(response) {
                        var body = response.data;

                        if ((typeof body === 'undefined' ? 'undefined' : _typeof(body)) === "object") {
                            body = JSON.stringify(body);
                        }

                        return "Oops, an error occured : (code: " + response.status + ") " + body;
                    }
                },
                entities: {
                    get: function get() {
                        return this._entities;
                    }
                },
                getViewsOfType: {
                    value: function getViewsOfType(type) {
                        return this._entities.map(function (entity) {
                            return entity.views[type];
                        });
                    }
                },
                getRouteFor: {
                    value: function getRouteFor(entity, viewUrl, viewType, identifierValue, identifierName) {
                        var baseApiUrl = entity.baseApiUrl() || this.baseApiUrl(),
                            url = viewUrl || entity.getUrl(viewType, identifierValue, identifierName);

                        // If the view or the entity don't define the url, retrieve it from the baseURL of the entity or the app
                        if (!url) {
                            url = baseApiUrl + entity.name();
                            if (identifierValue) {
                                url += "/" + identifierValue;
                            }
                        } else if (!/^(?:[a-z]+:)?\/\//.test(url)) {
                            // Add baseUrl for relative URL
                            url = baseApiUrl + url;
                        }

                        return url;
                    }
                },
                debug: {
                    value: function (_debug) {
                        var _debugWrapper = function debug(_x) {
                            return _debug.apply(this, arguments);
                        };

                        _debugWrapper.toString = function () {
                            return _debug.toString();
                        };

                        return _debugWrapper;
                    }(function (debug) {
                        if (!arguments.length) return this._debug;
                        this._debug = debug;
                        return this;
                    })
                },
                layout: {
                    value: function (_layout) {
                        var _layoutWrapper = function layout(_x2) {
                            return _layout.apply(this, arguments);
                        };

                        _layoutWrapper.toString = function () {
                            return _layout.toString();
                        };

                        return _layoutWrapper;
                    }(function (layout) {
                        if (!arguments.length) return this._layout;
                        this._layout = layout;
                        return this;
                    })
                },
                header: {
                    value: function (_header) {
                        var _headerWrapper = function header(_x3) {
                            return _header.apply(this, arguments);
                        };

                        _headerWrapper.toString = function () {
                            return _header.toString();
                        };

                        return _headerWrapper;
                    }(function (header) {
                        if (!arguments.length) return this._header;
                        this._header = header;
                        return this;
                    })
                },
                title: {
                    value: function (_title) {
                        var _titleWrapper = function title(_x4) {
                            return _title.apply(this, arguments);
                        };

                        _titleWrapper.toString = function () {
                            return _title.toString();
                        };

                        return _titleWrapper;
                    }(function (title) {
                        if (!arguments.length) return this._title;
                        this._title = title;
                        return this;
                    })
                },
                menu: {

                    /**
                     * Getter/Setter for the main application menu
                     *
                     * If the getter is called first, it will return a menu based on entities.
                     *
                     *     application.addEntity(new Entity('posts'));
                     *     application.addEntity(new Entity('comments'));
                     *     application.menu(); // Menu { children: [ Menu { title: "Posts" }, Menu { title: "Comments" } ]}
                     *
                     * If the setter is called first, all subsequent calls to the getter will return the set menu.
                     *
                     *     application.addEntity(new Entity('posts'));
                     *     application.addEntity(new Entity('comments'));
                     *     application.menu(new Menu().addChild(new Menu().title('Foo')));
                     *     application.menu(); // Menu { children: [ Menu { title: "Foo" } ]}
                     *
                     * @see Menu
                     */

                    value: function (_menu) {
                        var _menuWrapper = function menu(_x5) {
                            return _menu.apply(this, arguments);
                        };

                        _menuWrapper.toString = function () {
                            return _menu.toString();
                        };

                        return _menuWrapper;
                    }(function (menu) {
                        if (!arguments.length) {
                            if (!this._menu) {
                                this._menu = this.buildMenuFromEntities();
                            }
                            return this._menu;
                        };
                        this._menu = menu;
                        return this;
                    })
                },
                buildMenuFromEntities: {
                    value: function buildMenuFromEntities() {
                        return new Menu().children(this.entities.filter(function (entity) {
                            return entity.menuView().enabled;
                        }).sort(function (e1, e2) {
                            return e1.menuView().order() - e2.menuView().order();
                        }).map(function (entity) {
                            return new Menu().populateFromEntity(entity);
                        }));
                    }
                },
                customTemplate: {
                    value: function (_customTemplate) {
                        var _customTemplateWrapper = function customTemplate(_x6) {
                            return _customTemplate.apply(this, arguments);
                        };

                        _customTemplateWrapper.toString = function () {
                            return _customTemplate.toString();
                        };

                        return _customTemplateWrapper;
                    }(function (customTemplate) {
                        if (!arguments.length) return this._customTemplate;
                        this._customTemplate = customTemplate;
                        return this;
                    })
                },
                baseApiUrl: {
                    value: function baseApiUrl(url) {
                        if (!arguments.length) {
                            return this._baseApiUrl;
                        }this._baseApiUrl = url;
                        return this;
                    }
                },
                addEntity: {
                    value: function addEntity(entity) {
                        if (!entity) {
                            throw new Error("No entity given");
                        }

                        this._entities.push(entity);

                        return this;
                    }
                },
                getEntity: {
                    value: function getEntity(entityName) {
                        var foundEntity = this._entities.filter(function (e) {
                            return e.name() === entityName;
                        })[0];
                        if (!foundEntity) {
                            throw new Error("Unable to find entity \"" + entityName + "\"");
                        }

                        return foundEntity;
                    }
                },
                hasEntity: {
                    value: function hasEntity(fieldName) {
                        return !!this._entities.filter(function (f) {
                            return f.name() === fieldName;
                        }).length;
                    }
                },
                getViewByEntityAndType: {
                    value: function getViewByEntityAndType(entityName, type) {
                        return this._entities.filter(function (e) {
                            return e.name() === entityName;
                        })[0].views[type];
                    }
                },
                getErrorMessage: {
                    value: function getErrorMessage(response) {
                        if (typeof this._errorMessage === "function") {
                            return this._errorMessage(response);
                        }

                        return this._errorMessage;
                    }
                },
                errorMessage: {
                    value: function (_errorMessage) {
                        var _errorMessageWrapper = function errorMessage(_x7) {
                            return _errorMessage.apply(this, arguments);
                        };

                        _errorMessageWrapper.toString = function () {
                            return _errorMessage.toString();
                        };

                        return _errorMessageWrapper;
                    }(function (errorMessage) {
                        if (!arguments.length) return this._errorMessage;
                        this._errorMessage = errorMessage;
                        return this;
                    })
                },
                getErrorMessageFor: {
                    value: function getErrorMessageFor(view, response) {
                        return view.getErrorMessage(response) || view.getEntity().getErrorMessage(response) || this.getErrorMessage(response);
                    }
                },
                getEntityNames: {
                    value: function getEntityNames() {
                        return this.entities.map(function (f) {
                            return f.name();
                        });
                    }
                }
            });

            return Application;
        }();

        module.exports = Application;
    });
    //# sourceMappingURL=Application.js.map;
    define('DataStore/DataStore', ["exports", "module", "../Entry"], function (exports, module, _Entry) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Entry = _interopRequire(_Entry);

        var DataStore = function () {
            function DataStore() {
                _classCallCheck(this, DataStore);

                this._entries = {};
            }

            _createClass(DataStore, {
                setEntries: {
                    value: function setEntries(name, entries) {
                        this._entries[name] = entries;

                        return this;
                    }
                },
                addEntry: {
                    value: function addEntry(name, entry) {
                        if (!(name in this._entries)) {
                            this._entries[name] = [];
                        }

                        this._entries[name].push(entry);
                    }
                },
                getEntries: {
                    value: function getEntries(name) {
                        return this._entries[name] || [];
                    }
                },
                getFirstEntry: {
                    value: function getFirstEntry(name) {
                        var entries = this.getEntries(name);

                        return entries.length ? entries[0] : null;
                    }
                },
                getChoices: {
                    value: function getChoices(field) {
                        var identifier = field.targetEntity().identifier().name();
                        var name = field.targetField().name();

                        return this.getEntries(field.targetEntity().uniqueId + "_choices").map(function (entry) {
                            return {
                                value: entry.values[identifier],
                                label: entry.values[name]
                            };
                        });
                    }
                },
                createEntry: {
                    value: function createEntry(entityName, identifier, fields) {
                        var entry = new Entry.mapFromRest(entityName, identifier, fields, {});

                        fields.forEach(function (field) {
                            entry.values[field.name()] = field.defaultValue();
                        });

                        return entry;
                    }
                },
                mapEntry: {
                    value: function mapEntry(entityName, identifier, fields, restEntry) {
                        var entry = new Entry.mapFromRest(entityName, identifier, fields, restEntry);

                        return entry;
                    }
                },
                mapEntries: {
                    value: function mapEntries(entityName, identifier, fields, restEntries) {
                        var _this = this;

                        return restEntries.map(function (e) {
                            return _this.mapEntry(entityName, identifier, fields, e);
                        });
                    }
                },
                fillReferencesValuesFromCollection: {
                    value: function fillReferencesValuesFromCollection(collection, referencedValues, fillSimpleReference) {
                        fillSimpleReference = typeof fillSimpleReference === "undefined" ? false : fillSimpleReference;

                        var i, l;

                        for (i = 0, l = collection.length; i < l; i++) {
                            collection[i] = this.fillReferencesValuesFromEntry(collection[i], referencedValues, fillSimpleReference);
                        }

                        return collection;
                    }
                },
                fillReferencesValuesFromEntry: {
                    value: function fillReferencesValuesFromEntry(entry, referencedValues, fillSimpleReference) {
                        var reference, referenceField, choices, entries, identifier, id, i;

                        for (referenceField in referencedValues) {
                            reference = referencedValues[referenceField];
                            choices = this.getReferenceChoicesById(reference);
                            entries = [];
                            identifier = reference.getMappedValue(entry.values[referenceField], entry.values);

                            if (reference.type() === "reference_many") {
                                for (i in identifier) {
                                    id = identifier[i];
                                    entries.push(choices[id]);
                                }

                                entry.listValues[referenceField] = entries;
                            } else if (fillSimpleReference && identifier && identifier in choices) {
                                entry.listValues[referenceField] = reference.getMappedValue(choices[identifier], entry.values);
                            }
                        }

                        return entry;
                    }
                },
                getReferenceChoicesById: {
                    value: function getReferenceChoicesById(field) {
                        var result = {};
                        var targetField = field.targetField().name();
                        var targetIdentifier = field.targetEntity().identifier().name();
                        var entries = this.getEntries(field.targetEntity().uniqueId + "_values");

                        for (var i = 0, l = entries.length; i < l; i++) {
                            var entry = entries[i];
                            result[entry.values[targetIdentifier]] = entry.values[targetField];
                        }

                        return result;
                    }
                }
            });

            return DataStore;
        }();

        module.exports = DataStore;
    });
    //# sourceMappingURL=DataStore.js.map;
    define('Field/BooleanField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var BooleanField = function (_Field) {
            function BooleanField(name) {
                _classCallCheck(this, BooleanField);

                _get(Object.getPrototypeOf(BooleanField.prototype), "constructor", this).call(this, name);
                this._type = "boolean";
            }

            _inherits(BooleanField, _Field);

            return BooleanField;
        }(Field);

        module.exports = BooleanField;
    });
    //# sourceMappingURL=BooleanField.js.map;
    define('Field/ChoiceField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var ChoiceField = function (_Field) {
            function ChoiceField(name) {
                _classCallCheck(this, ChoiceField);

                _get(Object.getPrototypeOf(ChoiceField.prototype), "constructor", this).call(this, name);
                this._type = "choice";
                this._choices = [];
            }

            _inherits(ChoiceField, _Field);

            _createClass(ChoiceField, {
                choices: {
                    value: function (_choices) {
                        var _choicesWrapper = function choices(_x) {
                            return _choices.apply(this, arguments);
                        };

                        _choicesWrapper.toString = function () {
                            return _choices.toString();
                        };

                        return _choicesWrapper;
                    }(function (choices) {
                        if (!arguments.length) return this._choices;
                        this._choices = choices;

                        return this;
                    })
                },
                getLabelForChoice: {
                    value: function getLabelForChoice(value, entry) {
                        var choices = typeof this._choices === "function" ? this._choices(entry) : this._choices;
                        var choice = choices.filter(function (c) {
                            return c.value == value;
                        }).pop();
                        return choice ? choice.label : null;
                    }
                }
            });

            return ChoiceField;
        }(Field);

        module.exports = ChoiceField;
    });
    //# sourceMappingURL=ChoiceField.js.map;
    define('Field/ChoicesField', ["exports", "module", "./ChoiceField"], function (exports, module, _ChoiceField2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var ChoiceField = _interopRequire(_ChoiceField2);

        var ChoicesField = function (_ChoiceField) {
            function ChoicesField(name) {
                _classCallCheck(this, ChoicesField);

                _get(Object.getPrototypeOf(ChoicesField.prototype), "constructor", this).call(this, name);
                this._type = "choices";
            }

            _inherits(ChoicesField, _ChoiceField);

            return ChoicesField;
        }(ChoiceField);

        module.exports = ChoicesField;
    });
    //# sourceMappingURL=ChoicesField.js.map;
    define('Field/DateField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var DateField = function (_Field) {
            function DateField(name) {
                _classCallCheck(this, DateField);

                _get(Object.getPrototypeOf(DateField.prototype), "constructor", this).call(this, name);
                this._format = "yyyy-MM-dd";
                this._parse = function (date) {
                    if (date instanceof Date) {
                        // the datepicker returns a JS Date object, with hours, minutes and timezone
                        // in order to convert it back to date, we must remove the timezone, then
                        // remove hours and minutes
                        date.setMinutes(date.getMinutes() - date.getTimezoneOffset());
                        var dateString = date.toJSON();
                        return dateString ? dateString.substr(0, 10) : null;
                    }
                };
                this._type = "date";
            }

            _inherits(DateField, _Field);

            _createClass(DateField, {
                format: {
                    value: function format(value) {
                        if (!arguments.length) {
                            return this._format;
                        }this._format = value;
                        return this;
                    }
                },
                parse: {
                    value: function parse(value) {
                        if (!arguments.length) {
                            return this._parse;
                        }this._parse = value;
                        return this;
                    }
                }
            });

            return DateField;
        }(Field);

        module.exports = DateField;
    });
    //# sourceMappingURL=DateField.js.map;
    define('Field/DateTimeField', ["exports", "module", "./DateField"], function (exports, module, _DateField2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var DateField = _interopRequire(_DateField2);

        var DateTimeField = function (_DateField) {
            function DateTimeField(name) {
                _classCallCheck(this, DateTimeField);

                _get(Object.getPrototypeOf(DateTimeField.prototype), "constructor", this).call(this, name);
                this._format = "yyyy-MM-dd HH:mm:ss";
                this._parse = function (date) {
                    return date;
                };
            }

            _inherits(DateTimeField, _DateField);

            return DateTimeField;
        }(DateField);

        module.exports = DateField;
    });
    //# sourceMappingURL=DateTimeField.js.map;
    define('Field/EmailField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var EmailField = function (_Field) {
            function EmailField(name) {
                _classCallCheck(this, EmailField);

                _get(Object.getPrototypeOf(EmailField.prototype), "constructor", this).call(this, name);
                this._type = "email";
            }

            _inherits(EmailField, _Field);

            return EmailField;
        }(Field);

        module.exports = EmailField;
    });
    //# sourceMappingURL=EmailField.js.map;
    define('Field/FileField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var FileField = function (_Field) {
            function FileField(name) {
                _classCallCheck(this, FileField);

                _get(Object.getPrototypeOf(FileField.prototype), "constructor", this).call(this, name);
                this._type = "file";
                this._uploadInformation = {
                    url: "/upload",
                    accept: "*"
                };
            }

            _inherits(FileField, _Field);

            _createClass(FileField, {
                uploadInformation: {
                    value: function uploadInformation(information) {
                        if (!arguments.length) {
                            return this._uploadInformation;
                        }this._uploadInformation = information;
                        return this;
                    }
                }
            });

            return FileField;
        }(Field);

        module.exports = FileField;
    });
    //# sourceMappingURL=FileField.js.map;
    define('Field/JsonField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var JsonField = function (_Field) {
            function JsonField(name) {
                _classCallCheck(this, JsonField);

                _get(Object.getPrototypeOf(JsonField.prototype), "constructor", this).call(this, name);
                this._type = "json";
            }

            _inherits(JsonField, _Field);

            return JsonField;
        }(Field);

        module.exports = JsonField;
    });
    //# sourceMappingURL=JsonField.js.map;
    define('Field/NumberField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var NumberField = function (_Field) {
            function NumberField(name) {
                _classCallCheck(this, NumberField);

                _get(Object.getPrototypeOf(NumberField.prototype), "constructor", this).call(this, name);
                this._type = "number";
                this._format = undefined;
            }

            _inherits(NumberField, _Field);

            _createClass(NumberField, {
                format: {

                    /**
                     * Specify format pattern for number to string conversion. 
                     *
                     * Based on NumeralJs, which uses a syntax similar to Excel.
                     *
                     * {@link} http://numeraljs.com/
                     * {@link} https://github.com/baumandm/angular-numeraljs
                     * {@example}
                     *
                     *     nga.field('height', 'number').format('$0,0.00');
                     */

                    value: function format(value) {
                        if (!arguments.length) {
                            return this._format;
                        }this._format = value;
                        return this;
                    }
                },
                fractionSize: {
                    value: function fractionSize(decimals) {
                        console.warn("NumberField.fractionSize() is deprecated, use NumberField.format() instead");
                        this.format("0." + "0".repeat(decimals));
                        return this;
                    }
                }
            });

            return NumberField;
        }(Field);

        module.exports = NumberField;
    });
    //# sourceMappingURL=NumberField.js.map;
    define('Field/PasswordField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var PasswordField = function (_Field) {
            function PasswordField(name) {
                _classCallCheck(this, PasswordField);

                _get(Object.getPrototypeOf(PasswordField.prototype), "constructor", this).call(this, name);
                this._type = "password";
            }

            _inherits(PasswordField, _Field);

            return PasswordField;
        }(Field);

        module.exports = PasswordField;
    });
    //# sourceMappingURL=PasswordField.js.map;
    define('Field/ReferenceField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var ReferenceField = function (_Field) {
            function ReferenceField(name) {
                _classCallCheck(this, ReferenceField);

                _get(Object.getPrototypeOf(ReferenceField.prototype), "constructor", this).call(this, name);
                this._type = "reference";
                this._targetEntity = null;
                this._targetField = null;
                this._perPage = 30;
                this._filters = null;
                this._sortField = null;
                this._sortDir = null;
                this._singleApiCall = false;
                this._detailLink = true;
            }

            _inherits(ReferenceField, _Field);

            _createClass(ReferenceField, {
                perPage: {
                    value: function (_perPage) {
                        var _perPageWrapper = function perPage(_x) {
                            return _perPage.apply(this, arguments);
                        };

                        _perPageWrapper.toString = function () {
                            return _perPage.toString();
                        };

                        return _perPageWrapper;
                    }(function (perPage) {
                        if (!arguments.length) return this._perPage;
                        this._perPage = perPage;
                        return this;
                    })
                },
                datagridName: {
                    value: function datagridName() {
                        return this._targetEntity.name() + "_" + this._type;
                    }
                },
                targetEntity: {
                    value: function targetEntity(entity) {
                        if (!arguments.length) {
                            return this._targetEntity;
                        }
                        this._targetEntity = entity;

                        return this;
                    }
                },
                targetField: {
                    value: function targetField(field) {
                        if (!arguments.length) {
                            return this._targetField;
                        }this._targetField = field;

                        return this;
                    }
                },
                filters: {
                    value: function (_filters) {
                        var _filtersWrapper = function filters(_x2) {
                            return _filters.apply(this, arguments);
                        };

                        _filtersWrapper.toString = function () {
                            return _filters.toString();
                        };

                        return _filtersWrapper;
                    }(function (filters) {
                        if (!arguments.length) {
                            return this._filters;
                        }

                        this._filters = filters;

                        return this;
                    })
                },
                sortField: {
                    value: function sortField() {
                        if (arguments.length) {
                            this._sortField = arguments[0];
                            return this;
                        }

                        return this._sortField;
                    }
                },
                sortDir: {
                    value: function sortDir() {
                        if (arguments.length) {
                            this._sortDir = arguments[0];
                            return this;
                        }

                        return this._sortDir;
                    }
                },
                singleApiCall: {
                    value: function (_singleApiCall) {
                        var _singleApiCallWrapper = function singleApiCall(_x3) {
                            return _singleApiCall.apply(this, arguments);
                        };

                        _singleApiCallWrapper.toString = function () {
                            return _singleApiCall.toString();
                        };

                        return _singleApiCallWrapper;
                    }(function (singleApiCall) {
                        if (!arguments.length) return this._singleApiCall;
                        this._singleApiCall = singleApiCall;
                        return this;
                    })
                },
                hasSingleApiCall: {
                    value: function hasSingleApiCall() {
                        return typeof this._singleApiCall === "function";
                    }
                },
                getSingleApiCall: {
                    value: function getSingleApiCall(identifiers) {
                        return this.hasSingleApiCall() ? this._singleApiCall(identifiers) : this._singleApiCall;
                    }
                },
                getIdentifierValues: {
                    value: function getIdentifierValues(rawValues) {
                        var results = {};
                        var identifierName = this._name;
                        for (var i = 0, l = rawValues.length; i < l; i++) {
                            var identifier = rawValues[i][identifierName];
                            if (!identifier) {
                                continue;
                            }

                            if (identifier instanceof Array) {
                                for (var j in identifier) {
                                    results[identifier[j]] = true;
                                }
                                continue;
                            }

                            results[identifier] = true;
                        }

                        return Object.keys(results);
                    }
                },
                getSortFieldName: {
                    value: function getSortFieldName() {
                        return this._targetEntity.name() + "_ListView." + (this.sortField() || this._targetField.name());
                    }
                }
            });

            return ReferenceField;
        }(Field);

        module.exports = ReferenceField;
    });
    //# sourceMappingURL=ReferenceField.js.map;
    define('Field/ReferencedListField', ["exports", "module", "./ReferenceField"], function (exports, module, _ReferenceField2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var ReferenceField = _interopRequire(_ReferenceField2);

        var ReferencedListField = function (_ReferenceField) {
            function ReferencedListField(name) {
                _classCallCheck(this, ReferencedListField);

                _get(Object.getPrototypeOf(ReferencedListField.prototype), "constructor", this).call(this, name);
                this._type = "referenced_list";
                this._targetReferenceField = null;
                this._targetFields = [];
                this._detailLink = false;
            }

            _inherits(ReferencedListField, _ReferenceField);

            _createClass(ReferencedListField, {
                targetReferenceField: {
                    value: function targetReferenceField(value) {
                        if (!arguments.length) {
                            return this._targetReferenceField;
                        }this._targetReferenceField = value;
                        return this;
                    }
                },
                targetFields: {
                    value: function targetFields(value) {
                        if (!arguments.length) {
                            return this._targetFields;
                        }this._targetFields = value;

                        return this;
                    }
                },
                getGridColumns: {
                    value: function getGridColumns() {
                        var columns = [];
                        for (var i = 0, l = this._targetFields.length; i < l; i++) {
                            var field = this._targetFields[i];
                            columns.push({
                                field: field,
                                label: field.label()
                            });
                        }

                        return columns;
                    }
                },
                getSortFieldName: {
                    value: function getSortFieldName() {
                        return this._targetEntity.name() + "_ListView." + (this.sortField() || this._targetReferenceField);
                    }
                }
            });

            return ReferencedListField;
        }(ReferenceField);

        module.exports = ReferencedListField;
    });
    //# sourceMappingURL=ReferencedListField.js.map;
    define('Field/ReferenceManyField', ["exports", "module", "./ReferenceField"], function (exports, module, _ReferenceField2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var ReferenceField = _interopRequire(_ReferenceField2);

        var ReferenceManyField = function (_ReferenceField) {
            function ReferenceManyField(name) {
                _classCallCheck(this, ReferenceManyField);

                _get(Object.getPrototypeOf(ReferenceManyField.prototype), "constructor", this).call(this, name);
                this._type = "reference_many";
            }

            _inherits(ReferenceManyField, _ReferenceField);

            return ReferenceManyField;
        }(ReferenceField);

        module.exports = ReferenceManyField;
    });
    //# sourceMappingURL=ReferenceManyField.js.map;
    define('Field/TemplateField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var TemplateField = function (_Field) {
            function TemplateField(name) {
                _classCallCheck(this, TemplateField);

                _get(Object.getPrototypeOf(TemplateField.prototype), "constructor", this).call(this, name);
                this._template = function () {
                    return "";
                };
                this._type = "template";
            }

            _inherits(TemplateField, _Field);

            _createClass(TemplateField, {
                getTemplateValue: {
                    value: function getTemplateValue(data) {
                        if (typeof this._template === "function") {
                            return this._template(data);
                        }

                        return this._template;
                    }
                },
                template: {
                    value: function (_template) {
                        var _templateWrapper = function template(_x) {
                            return _template.apply(this, arguments);
                        };

                        _templateWrapper.toString = function () {
                            return _template.toString();
                        };

                        return _templateWrapper;
                    }(function (template) {
                        if (!arguments.length) return this._template;
                        this._template = template;
                        return this;
                    })
                }
            });

            return TemplateField;
        }(Field);

        module.exports = TemplateField;
    });
    //# sourceMappingURL=TemplateField.js.map;
    define('Field/TextField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var TextField = function (_Field) {
            function TextField(name) {
                _classCallCheck(this, TextField);

                _get(Object.getPrototypeOf(TextField.prototype), "constructor", this).call(this, name);
                this._type = "text";
            }

            _inherits(TextField, _Field);

            return TextField;
        }(Field);

        module.exports = TextField;
    });
    //# sourceMappingURL=TextField.js.map;
    define('Field/WysiwygField', ["exports", "module", "./Field"], function (exports, module, _Field2) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _get = function get(object, property, receiver) {
            var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
                var parent = Object.getPrototypeOf(object);if (parent === null) {
                    return undefined;
                } else {
                    return get(parent, property, receiver);
                }
            } else if ("value" in desc && desc.writable) {
                return desc.value;
            } else {
                var getter = desc.get;if (getter === undefined) {
                    return undefined;
                }return getter.call(receiver);
            }
        };

        var _inherits = function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === 'undefined' ? 'undefined' : _typeof(superClass)));
            }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) subClass.__proto__ = superClass;
        };

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Field = _interopRequire(_Field2);

        var WysiwygField = function (_Field) {
            function WysiwygField(name) {
                _classCallCheck(this, WysiwygField);

                _get(Object.getPrototypeOf(WysiwygField.prototype), "constructor", this).call(this, name);
                this._type = "wysiwyg";
                this._stripTags = false;
                this._sanitize = true;
            }

            _inherits(WysiwygField, _Field);

            _createClass(WysiwygField, {
                stripTags: {
                    value: function stripTags(value) {
                        if (!arguments.length) {
                            return this._stripTags;
                        }this._stripTags = value;
                        return this;
                    }
                },
                sanitize: {
                    value: function sanitize(value) {
                        if (!arguments.length) {
                            return this._sanitize;
                        }this._sanitize = value;
                        return this;
                    }
                }
            });

            return WysiwygField;
        }(Field);

        module.exports = WysiwygField;
    });
    //# sourceMappingURL=WysiwygField.js.map;
    define('Factory.js', ["exports", "module", "./Application", "./Entity/Entity", "./DataStore/DataStore", "./Field/Field", "./Field/BooleanField", "./Field/ChoiceField", "./Field/ChoicesField", "./Field/DateField", "./Field/DateTimeField", "./Field/EmailField", "./Field/FileField", "./Field/JsonField", "./Field/NumberField", "./Field/PasswordField", "./Field/ReferenceField", "./Field/ReferencedListField", "./Field/ReferenceManyField", "./Field/TemplateField", "./Field/TextField", "./Field/WysiwygField", "./Menu/Menu"], function (exports, module, _Application, _EntityEntity, _DataStoreDataStore, _FieldField, _FieldBooleanField, _FieldChoiceField, _FieldChoicesField, _FieldDateField, _FieldDateTimeField, _FieldEmailField, _FieldFileField, _FieldJsonField, _FieldNumberField, _FieldPasswordField, _FieldReferenceField, _FieldReferencedListField, _FieldReferenceManyField, _FieldTemplateField, _FieldTextField, _FieldWysiwygField, _MenuMenu) {
        "use strict";

        var _interopRequire = function _interopRequire(obj) {
            return obj && obj.__esModule ? obj["default"] : obj;
        };

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var key in props) {
                    var prop = props[key];prop.configurable = true;if (prop.value) prop.writable = true;
                }Object.defineProperties(target, props);
            }return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
            };
        }();

        var _classCallCheck = function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        };

        var Application = _interopRequire(_Application);

        var Entity = _interopRequire(_EntityEntity);

        var DataStore = _interopRequire(_DataStoreDataStore);

        var Field = _interopRequire(_FieldField);

        var BooleanField = _interopRequire(_FieldBooleanField);

        var ChoiceField = _interopRequire(_FieldChoiceField);

        var ChoicesField = _interopRequire(_FieldChoicesField);

        var DateField = _interopRequire(_FieldDateField);

        var DateTimeField = _interopRequire(_FieldDateTimeField);

        var EmailField = _interopRequire(_FieldEmailField);

        var FileField = _interopRequire(_FieldFileField);

        var JsonField = _interopRequire(_FieldJsonField);

        var NumberField = _interopRequire(_FieldNumberField);

        var PasswordField = _interopRequire(_FieldPasswordField);

        var ReferenceField = _interopRequire(_FieldReferenceField);

        var ReferencedListField = _interopRequire(_FieldReferencedListField);

        var ReferenceManyField = _interopRequire(_FieldReferenceManyField);

        var TemplateField = _interopRequire(_FieldTemplateField);

        var TextField = _interopRequire(_FieldTextField);

        var WysiwygField = _interopRequire(_FieldWysiwygField);

        var Menu = _interopRequire(_MenuMenu);

        var Factory = function () {
            function Factory() {
                _classCallCheck(this, Factory);

                this._fieldTypes = [];
                this._init();
            }

            _createClass(Factory, {
                application: {
                    value: function application(name, baseApiUrl) {
                        return new Application(name, baseApiUrl);
                    }
                },
                entity: {
                    value: function entity(name) {
                        return new Entity(name);
                    }
                },
                field: {
                    value: function field(name, type) {
                        type = type || "string";

                        if (!(type in this._fieldTypes)) {
                            throw new Error("Unknown field type \"" + type + "\".");
                        }

                        return new this._fieldTypes[type](name);
                    }
                },
                registerFieldType: {
                    value: function registerFieldType(name, constructor) {
                        this._fieldTypes[name] = constructor;
                    }
                },
                getFieldConstructor: {
                    value: function getFieldConstructor(name) {
                        return this._fieldTypes[name];
                    }
                },
                menu: {
                    value: function menu(entity) {
                        var menu = new Menu();
                        if (entity) {
                            menu.populateFromEntity(entity);
                        }
                        return menu;
                    }
                },
                getDataStore: {
                    value: function getDataStore() {
                        return new DataStore();
                    }
                },
                _init: {
                    value: function _init() {
                        this.registerFieldType("boolean", BooleanField);
                        this.registerFieldType("choice", ChoiceField);
                        this.registerFieldType("choices", ChoicesField);
                        this.registerFieldType("date", DateField);
                        this.registerFieldType("datetime", DateTimeField);
                        this.registerFieldType("email", EmailField);
                        this.registerFieldType("string", Field);
                        this.registerFieldType("file", FileField);
                        this.registerFieldType("json", JsonField);
                        this.registerFieldType("number", NumberField);
                        this.registerFieldType("password", PasswordField);
                        this.registerFieldType("reference", ReferenceField);
                        this.registerFieldType("reference_many", ReferenceManyField);
                        this.registerFieldType("referenced_list", ReferencedListField);
                        this.registerFieldType("template", TemplateField);
                        this.registerFieldType("text", TextField);
                        this.registerFieldType("wysiwyg", WysiwygField);
                    }
                }
            });

            return Factory;
        }();

        module.exports = Factory;
    });
    //# sourceMappingURL=Factory.js.map;
    return require('Factory.js');
});
//# sourceMappingURL=ng-admin-configuration.js.map