import { Component, Inject } from '@angular/core';
import { Router } from '@angular/router';
import { SettingsService } from '@delon/theme';
import { DA_SERVICE_TOKEN, ITokenService } from '@delon/auth';

@Component({
  selector: 'header-user',
  template: `
  <nz-dropdown nzPlacement="bottomRight">
    <div class="alain-default__nav-item d-flex align-items-center px-sm" nz-dropdown>
      <nz-avatar [nzSrc]="settings.user.avatar" nzSize="small" class="mr-sm"></nz-avatar>
      {{settings.user.name}}
    </div>
    <div nz-menu class="width-sm">
      <div nz-menu-item routerLink="/pro/account/center"><i class="anticon anticon-user mr-sm"></i>
        <% if (i18n) { %>{{ 'menu.account.center' | translate }}<% } else { %>个人中心<% } %>
      </div>
      <div nz-menu-item routerLink="/pro/account/settings"><i class="anticon anticon-setting mr-sm"></i>
        <% if (i18n) { %>{{ 'menu.account.settings' | translate }}<% } else { %>个人设置<% } %>
      </div>
      <li nz-menu-divider></li>
      <div nz-menu-item (click)="logout()"><i class="anticon anticon-logout mr-sm"></i>
        <% if (i18n) { %>{{ 'menu.account.logout' | translate }}<% } else { %>退出登录<% } %>
      </div>
    </div>
  </nz-dropdown>
  `,
})
export class HeaderUserComponent {
  constructor(
    public settings: SettingsService,
    private router: Router,
    @Inject(DA_SERVICE_TOKEN) private tokenService: ITokenService,
  ) {}

  logout() {
    this.tokenService.clear();
    this.router.navigateByUrl(this.tokenService.login_url);
  }
}
