var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var core_1 = require('angular2/core');
var common_1 = require('angular2/common');
var collapse_1 = require('../collapse/collapse');
// todo: support template url
var Accordion = (function () {
    function Accordion() {
        this.addPanelGroupClass = true;
        this.groups = [];
    }
    Accordion.prototype.closeOtherGroups = function (openGroup) {
        if (!this.closeOthers) {
            return;
        }
        this.groups.forEach(function (group) {
            if (group !== openGroup) {
                group.isOpen = false;
            }
        });
    };
    Accordion.prototype.addGroup = function (group) {
        this.groups.push(group);
    };
    Accordion.prototype.removeGroup = function (group) {
        var index = this.groups.indexOf(group);
        if (index !== -1) {
            this.groups.slice(index, 1);
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], Accordion.prototype, "templateUrl", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], Accordion.prototype, "closeOthers", void 0);
    __decorate([
        core_1.HostBinding('class.panel-group'), 
        __metadata('design:type', Object)
    ], Accordion.prototype, "addPanelGroupClass", void 0);
    Accordion = __decorate([
        core_1.Component({
            selector: 'accordion',
            template: "<ng-content></ng-content>"
        }), 
        __metadata('design:paramtypes', [])
    ], Accordion);
    return Accordion;
})();
exports.Accordion = Accordion;
var AccordionTransclude = (function () {
    function AccordionTransclude(viewRef) {
        this.viewRef = viewRef;
    }
    AccordionTransclude.prototype.ngOnInit = function () {
        if (this.accordionTransclude) {
            this.viewRef.createEmbeddedView(this.accordionTransclude);
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', core_1.TemplateRef)
    ], AccordionTransclude.prototype, "accordionTransclude", void 0);
    AccordionTransclude = __decorate([
        core_1.Directive({
            selector: '[accordionTransclude]'
        }),
        __param(0, core_1.Inject(core_1.ViewContainerRef)), 
        __metadata('design:paramtypes', [core_1.ViewContainerRef])
    ], AccordionTransclude);
    return AccordionTransclude;
})();
exports.AccordionTransclude = AccordionTransclude;
// todo: support template url
// todo: support custom `open class`
var AccordionGroup = (function () {
    function AccordionGroup(accordion) {
        this.accordion = accordion;
    }
    Object.defineProperty(AccordionGroup.prototype, "isOpen", {
        get: function () {
            return this._isOpen;
        },
        set: function (value) {
            this._isOpen = value;
            if (value) {
                this.accordion.closeOtherGroups(this);
            }
        },
        enumerable: true,
        configurable: true
    });
    AccordionGroup.prototype.ngOnInit = function () {
        this.panelClass = this.panelClass || 'panel-default';
        this.accordion.addGroup(this);
    };
    AccordionGroup.prototype.ngOnDestroy = function () {
        this.accordion.removeGroup(this);
    };
    AccordionGroup.prototype.toggleOpen = function (event) {
        event.preventDefault();
        if (!this.isDisabled) {
            this.isOpen = !this.isOpen;
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], AccordionGroup.prototype, "templateUrl", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], AccordionGroup.prototype, "heading", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], AccordionGroup.prototype, "panelClass", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], AccordionGroup.prototype, "isDisabled", void 0);
    __decorate([
        core_1.HostBinding('class.panel-open'),
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], AccordionGroup.prototype, "isOpen", null);
    AccordionGroup = __decorate([
        core_1.Component({
            selector: 'accordion-group',
            directives: [collapse_1.Collapse, AccordionTransclude, common_1.NgClass],
            template: "\n    <div class=\"panel\" [ngClass]=\"panelClass\">\n      <div class=\"panel-heading\" (click)=\"toggleOpen($event)\">\n        <h4 class=\"panel-title\">\n          <a href tabindex=\"0\" class=\"accordion-toggle\">\n            <span [ngClass]=\"{'text-muted': isDisabled}\"\n              [accordionTransclude]=\"headingTemplate\">{{heading}}</span>\n          </a>\n        </h4>\n      </div>\n      <div class=\"panel-collapse collapse\" [collapse]=\"!isOpen\">\n        <div class=\"panel-body\">\n          <ng-content></ng-content>\n        </div>\n      </div>\n    </div>\n  "
        }), 
        __metadata('design:paramtypes', [Accordion])
    ], AccordionGroup);
    return AccordionGroup;
})();
exports.AccordionGroup = AccordionGroup;
var AccordionHeading = (function () {
    function AccordionHeading(group, templateRef) {
        this.group = group;
        this.templateRef = templateRef;
        group.headingTemplate = templateRef;
    }
    AccordionHeading = __decorate([
        core_1.Directive({ selector: '[accordion-heading]' }), 
        __metadata('design:paramtypes', [AccordionGroup, core_1.TemplateRef])
    ], AccordionHeading);
    return AccordionHeading;
})();
exports.AccordionHeading = AccordionHeading;
exports.ACCORDION_DIRECTIVES = [Accordion, AccordionGroup, AccordionHeading];
// will be deprecated
exports.accordion = [Accordion, AccordionGroup, AccordionHeading];
//# sourceMappingURL=accordion.js.map