import { QueryList, AfterContentChecked } from '@angular/core';
/**
 * The NgbPanel directive builds on top of the NgbCollapse directive to provide a panel with collapsible body that can
 * collapsed or expanded by clicking on the panel's header.
 */
export declare class NgbPanel {
    private accordion;
    /**
     *  A flag determining whether the panel is disabled or not.
     *  When disabled, the panel cannot be toggled.
     */
    disabled: boolean;
    /**
     *  An optional id for the panel. The id should be unique.
     *  If not provided, it will be auto-generated.
     */
    id: string;
    /**
     *  Defines whether the panel should be open initially.
     */
    open: boolean;
    /**
     *  The title for the panel.
     */
    title: string;
    constructor(accordion: NgbAccordion);
    toggleOpen(event: any): void;
}
/**
 * The NgbAccordion directive is a collection of panels.
 * NgbAccordion can assure that only panel can be opened at a time.
 */
export declare class NgbAccordion implements AfterContentChecked {
    _panels: QueryList<NgbPanel>;
    /**
     *  A flag determining whether the other panels should be closed
     *  when a panel is opened.
     */
    closeOtherPanels: boolean;
    closeOthers(openPanel: NgbPanel): void;
    ngAfterContentChecked(): void;
}
export declare const NGB_ACCORDION_DIRECTIVES: (typeof NgbAccordion | typeof NgbPanel)[];
