"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var core_1 = require('@angular/core');
var collapse_1 = require('../collapse/collapse');
var nextId = 0;
/**
 * The NgbPanel directive builds on top of the NgbCollapse directive to provide a panel with collapsible body that can
 * collapsed or expanded by clicking on the panel's header.
 */
var NgbPanel = (function () {
    function NgbPanel(accordion) {
        this.accordion = accordion;
        /**
         *  A flag determining whether the panel is disabled or not.
         *  When disabled, the panel cannot be toggled.
         */
        this.disabled = false;
        /**
         *  An optional id for the panel. The id should be unique.
         *  If not provided, it will be auto-generated.
         */
        this.id = "ngb-panel-" + nextId++;
        /**
         *  Defines whether the panel should be open initially.
         */
        this.open = false;
    }
    NgbPanel.prototype.toggleOpen = function (event) {
        event.preventDefault();
        if (!this.disabled) {
            this.open = !this.open;
            if (this.open && this.accordion) {
                this.accordion.closeOthers(this);
            }
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPanel.prototype, "disabled", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPanel.prototype, "id", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPanel.prototype, "open", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbPanel.prototype, "title", void 0);
    NgbPanel = __decorate([
        core_1.Component({
            selector: 'ngb-panel',
            exportAs: 'ngbPanel',
            template: "\n    <div class=\"panel panel-default\" [class.panel-open]=\"open\">\n      <div class=\"panel-heading\" role=\"tab\" [id]=\"id\">\n        <h4 class=\"panel-title\">\n          <a tabindex=\"0\" (click)=\"toggleOpen($event)\"><span [class.text-muted]=\"disabled\">{{title}}</span></a>\n        </h4>\n      </div>\n      <div class=\"panel-collapse\" [ngbCollapse]=\"!open\" [attr.aria-labelledby]=\"id\" role=\"tabpanel\">\n        <div class=\"panel-body\">\n          <ng-content></ng-content>\n        </div>\n      </div>\n    </div>\n  ",
            directives: [collapse_1.NgbCollapse]
        }),
        __param(0, core_1.Optional()),
        __param(0, core_1.Inject(core_1.forwardRef(function () { return NgbAccordion; }))), 
        __metadata('design:paramtypes', [NgbAccordion])
    ], NgbPanel);
    return NgbPanel;
}());
exports.NgbPanel = NgbPanel;
/**
 * The NgbAccordion directive is a collection of panels.
 * NgbAccordion can assure that only panel can be opened at a time.
 */
var NgbAccordion = (function () {
    function NgbAccordion() {
    }
    NgbAccordion.prototype.closeOthers = function (openPanel) {
        if (this.closeOtherPanels) {
            this._panels.forEach(function (panel) {
                if (panel !== openPanel) {
                    panel.open = false;
                }
            });
        }
    };
    NgbAccordion.prototype.ngAfterContentChecked = function () {
        var openPanels = this._panels.toArray().filter(function (panel) { return panel.open; });
        if (openPanels.length > 1) {
            this.closeOthers(openPanels[0]);
        }
    };
    __decorate([
        core_1.ContentChildren(NgbPanel), 
        __metadata('design:type', core_1.QueryList)
    ], NgbAccordion.prototype, "_panels", void 0);
    __decorate([
        core_1.Input('closeOthers'), 
        __metadata('design:type', Boolean)
    ], NgbAccordion.prototype, "closeOtherPanels", void 0);
    NgbAccordion = __decorate([
        core_1.Component({
            selector: 'ngb-accordion',
            host: { 'role': 'tablist', '[attr.aria-multiselectable]': '!closeOtherPanels' },
            template: "<ng-content></ng-content>"
        }), 
        __metadata('design:paramtypes', [])
    ], NgbAccordion);
    return NgbAccordion;
}());
exports.NgbAccordion = NgbAccordion;
exports.NGB_ACCORDION_DIRECTIVES = [NgbAccordion, NgbPanel];

//# sourceMappingURL=accordion.js.map
