import { EventEmitter, OnInit, ViewContainerRef, Injector, OnDestroy, ComponentFactoryResolver, TemplateRef } from '@angular/core';
/**
 * Alerts can be used to provide feedback messages.
 */
export declare class NgbAlert {
    /**
     * A flag indicating if a given alert can be dismissed (closed) by a user. If this flag is set, a close button (in a
     * form of a cross) will be displayed.
     */
    dismissible: boolean;
    /**
     * Alert type (CSS class). Bootstrap 4 recognizes the following types: "success", "info", "warning" and "danger".
     */
    type: string;
    /**
     * An event emitted when the close button is clicked. This event has no payload. Only relevant for dismissible alerts.
     */
    close: EventEmitter<{}>;
    closeHandler(): void;
}
/**
 * Alerts that can be dismissed without any additional code.
 */
export declare class NgbDismissibleAlert implements OnInit, OnDestroy {
    private _templateRef;
    private _viewContainerRef;
    private _injector;
    private _windowFactory;
    private _windowRef;
    private _timeout;
    /**
     * Alert type (CSS class). Bootstrap 4 recognizes the following types: "success", "info", "warning" and "danger".
     */
    type: string;
    /**
     * An event emitted when the close button is clicked.
     */
    closeEvent: EventEmitter<{}>;
    /**
     *  Time, in milliseconds, before the alert auto closes.
     */
    dismissOnTimeout: number;
    constructor(_templateRef: TemplateRef<Object>, _viewContainerRef: ViewContainerRef, _injector: Injector, componentFactoryResolver: ComponentFactoryResolver);
    close(): void;
    ngOnInit(): void;
    ngOnDestroy(): void;
}
export declare const NGB_ALERT_DIRECTIVES: (typeof NgbAlert | typeof NgbDismissibleAlert)[];
