"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
/**
 * Transforms a node into a dropdown.
 */
var NgbDropdown = (function () {
    function NgbDropdown() {
        /**
         * Indicates that dropdown should be closed when selecting one of dropdown items (click) or pressing ESC.
         */
        this.autoClose = true;
        /**
         *  Defines whether or not the dropdown-menu is open initially.
         */
        this._open = false;
        /**
         *  An event fired when the dropdown is opened or closed.
         *  Event's payload equals whether dropdown is open.
         */
        this.openChange = new core_1.EventEmitter();
    }
    NgbDropdown.prototype.isOpen = function () { return this._open; };
    NgbDropdown.prototype.open = function () {
        this._open = true;
        this.openChange.emit(true);
    };
    NgbDropdown.prototype.close = function () {
        this._open = false;
        this.openChange.emit(false);
    };
    NgbDropdown.prototype.toggle = function () {
        if (this.isOpen()) {
            this.close();
        }
        else {
            this.open();
        }
    };
    NgbDropdown.prototype._closeFromOutside = function () {
        if (this.autoClose) {
            this.close();
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbDropdown.prototype, "autoClose", void 0);
    __decorate([
        core_1.Input('open'), 
        __metadata('design:type', Object)
    ], NgbDropdown.prototype, "_open", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbDropdown.prototype, "openChange", void 0);
    NgbDropdown = __decorate([
        core_1.Directive({
            selector: '[ngbDropdown]',
            exportAs: 'ngbDropdown',
            host: {
                'class': 'dropdown',
                '[class.open]': '_open',
                '(keyup.esc)': '_closeFromOutside()',
                '(document:click)': '_closeFromOutside()'
            }
        }), 
        __metadata('design:paramtypes', [])
    ], NgbDropdown);
    return NgbDropdown;
}());
exports.NgbDropdown = NgbDropdown;
/**
 * Allows the dropdown to be toggled via click. This directive is optional.
 */
var NgbDropdownToggle = (function () {
    function NgbDropdownToggle(_dropdown) {
        this._dropdown = _dropdown;
    }
    NgbDropdownToggle.prototype.toggleOpen = function ($event) {
        $event.stopPropagation();
        this._dropdown.toggle();
    };
    __decorate([
        core_1.HostListener('click', ['$event']), 
        __metadata('design:type', Function), 
        __metadata('design:paramtypes', [Object]), 
        __metadata('design:returntype', void 0)
    ], NgbDropdownToggle.prototype, "toggleOpen", null);
    NgbDropdownToggle = __decorate([
        core_1.Directive({
            selector: '[ngbDropdownToggle]',
            host: { 'class': 'dropdown-toggle', 'aria-haspopup': 'true', '[attr.aria-expanded]': '_dropdown.isOpen()' }
        }), 
        __metadata('design:paramtypes', [NgbDropdown])
    ], NgbDropdownToggle);
    return NgbDropdownToggle;
}());
exports.NgbDropdownToggle = NgbDropdownToggle;
exports.NGB_DROPDOWN_DIRECTIVES = [NgbDropdownToggle, NgbDropdown];

//# sourceMappingURL=dropdown.js.map
