var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Component, forwardRef, Inject, Input, QueryList, ContentChildren, Optional } from '@angular/core';
import { NgbCollapse } from '../collapse/collapse';
let nextId = 0;
/**
 * The NgbPanel directive builds on top of the NgbCollapse directive to provide a panel with collapsible body that can
 * collapsed or expanded by clicking on the panel's header.
 */
export let NgbPanel = class NgbPanel {
    constructor(accordion) {
        this.accordion = accordion;
        /**
         *  A flag determining whether the panel is disabled or not.
         *  When disabled, the panel cannot be toggled.
         */
        this.disabled = false;
        /**
         *  An optional id for the panel. The id should be unique.
         *  If not provided, it will be auto-generated.
         */
        this.id = `ngb-panel-${nextId++}`;
        /**
         *  Defines whether the panel should be open initially.
         */
        this.open = false;
    }
    toggleOpen(event) {
        event.preventDefault();
        if (!this.disabled) {
            this.open = !this.open;
            if (this.open && this.accordion) {
                this.accordion.closeOthers(this);
            }
        }
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPanel.prototype, "disabled", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPanel.prototype, "id", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPanel.prototype, "open", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbPanel.prototype, "title", void 0);
NgbPanel = __decorate([
    Component({
        selector: 'ngb-panel',
        exportAs: 'ngbPanel',
        template: `
    <div class="panel panel-default" [class.panel-open]="open">
      <div class="panel-heading" role="tab" [id]="id">
        <h4 class="panel-title">
          <a tabindex="0" (click)="toggleOpen($event)"><span [class.text-muted]="disabled">{{title}}</span></a>
        </h4>
      </div>
      <div class="panel-collapse" [ngbCollapse]="!open" [attr.aria-labelledby]="id" role="tabpanel">
        <div class="panel-body">
          <ng-content></ng-content>
        </div>
      </div>
    </div>
  `,
        directives: [NgbCollapse]
    }),
    __param(0, Optional()),
    __param(0, Inject(forwardRef(() => NgbAccordion))), 
    __metadata('design:paramtypes', [NgbAccordion])
], NgbPanel);
/**
 * The NgbAccordion directive is a collection of panels.
 * NgbAccordion can assure that only panel can be opened at a time.
 */
export let NgbAccordion = class NgbAccordion {
    closeOthers(openPanel) {
        if (this.closeOtherPanels) {
            this._panels.forEach((panel) => {
                if (panel !== openPanel) {
                    panel.open = false;
                }
            });
        }
    }
    ngAfterContentChecked() {
        const openPanels = this._panels.toArray().filter((panel) => panel.open);
        if (openPanels.length > 1) {
            this.closeOthers(openPanels[0]);
        }
    }
};
__decorate([
    ContentChildren(NgbPanel), 
    __metadata('design:type', QueryList)
], NgbAccordion.prototype, "_panels", void 0);
__decorate([
    Input('closeOthers'), 
    __metadata('design:type', Boolean)
], NgbAccordion.prototype, "closeOtherPanels", void 0);
NgbAccordion = __decorate([
    Component({
        selector: 'ngb-accordion',
        host: { 'role': 'tablist', '[attr.aria-multiselectable]': '!closeOtherPanels' },
        template: `<ng-content></ng-content>`
    }), 
    __metadata('design:paramtypes', [])
], NgbAccordion);
export const NGB_ACCORDION_DIRECTIVES = [NgbAccordion, NgbPanel];

//# sourceMappingURL=accordion.js.map
