var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Directive, Input, Output, HostListener, EventEmitter } from '@angular/core';
/**
 * Transforms a node into a dropdown.
 */
export let NgbDropdown = class NgbDropdown {
    constructor() {
        /**
         * Indicates that dropdown should be closed when selecting one of dropdown items (click) or pressing ESC.
         */
        this.autoClose = true;
        /**
         *  Defines whether or not the dropdown-menu is open initially.
         */
        this._open = false;
        /**
         *  An event fired when the dropdown is opened or closed.
         *  Event's payload equals whether dropdown is open.
         */
        this.openChange = new EventEmitter();
    }
    isOpen() { return this._open; }
    open() {
        this._open = true;
        this.openChange.emit(true);
    }
    close() {
        this._open = false;
        this.openChange.emit(false);
    }
    toggle() {
        if (this.isOpen()) {
            this.close();
        }
        else {
            this.open();
        }
    }
    _closeFromOutside() {
        if (this.autoClose) {
            this.close();
        }
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbDropdown.prototype, "autoClose", void 0);
__decorate([
    Input('open'), 
    __metadata('design:type', Object)
], NgbDropdown.prototype, "_open", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbDropdown.prototype, "openChange", void 0);
NgbDropdown = __decorate([
    Directive({
        selector: '[ngbDropdown]',
        exportAs: 'ngbDropdown',
        host: {
            'class': 'dropdown',
            '[class.open]': '_open',
            '(keyup.esc)': '_closeFromOutside()',
            '(document:click)': '_closeFromOutside()'
        }
    }), 
    __metadata('design:paramtypes', [])
], NgbDropdown);
/**
 * Allows the dropdown to be toggled via click. This directive is optional.
 */
export let NgbDropdownToggle = class NgbDropdownToggle {
    constructor(_dropdown) {
        this._dropdown = _dropdown;
    }
    toggleOpen($event) {
        $event.stopPropagation();
        this._dropdown.toggle();
    }
};
__decorate([
    HostListener('click', ['$event']), 
    __metadata('design:type', Function), 
    __metadata('design:paramtypes', [Object]), 
    __metadata('design:returntype', void 0)
], NgbDropdownToggle.prototype, "toggleOpen", null);
NgbDropdownToggle = __decorate([
    Directive({
        selector: '[ngbDropdownToggle]',
        host: { 'class': 'dropdown-toggle', 'aria-haspopup': 'true', '[attr.aria-expanded]': '_dropdown.isOpen()' }
    }), 
    __metadata('design:paramtypes', [NgbDropdown])
], NgbDropdownToggle);
export const NGB_DROPDOWN_DIRECTIVES = [NgbDropdownToggle, NgbDropdown];

//# sourceMappingURL=dropdown.js.map
