var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Output, EventEmitter, Input, HostListener } from '@angular/core';
import { ModalDismissReasons } from './modal_dismiss_reasons';
export let NgbModalWindow = class NgbModalWindow {
    constructor() {
        this.backdrop = true;
        this.keyboard = true;
        this.closeEvent = new EventEmitter();
        this.dismissEvent = new EventEmitter();
    }
    backdropClick() {
        if (this.backdrop) {
            this.dismiss(ModalDismissReasons.BACKDROP_CLICK);
        }
    }
    escKey() {
        if (this.keyboard) {
            this.dismiss(ModalDismissReasons.ESC);
        }
    }
    close(result) { this.closeEvent.emit(result); }
    dismiss(reason) { this.dismissEvent.emit(reason); }
    stopPropagation($event) { $event.stopPropagation(); }
};
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbModalWindow.prototype, "backdrop", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Boolean)
], NgbModalWindow.prototype, "keyboard", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbModalWindow.prototype, "size", void 0);
__decorate([
    Output('close'), 
    __metadata('design:type', Object)
], NgbModalWindow.prototype, "closeEvent", void 0);
__decorate([
    Output('dismiss'), 
    __metadata('design:type', Object)
], NgbModalWindow.prototype, "dismissEvent", void 0);
__decorate([
    HostListener('click'), 
    __metadata('design:type', Function), 
    __metadata('design:paramtypes', []), 
    __metadata('design:returntype', void 0)
], NgbModalWindow.prototype, "backdropClick", null);
__decorate([
    HostListener('keyup.esc'), 
    __metadata('design:type', Function), 
    __metadata('design:paramtypes', []), 
    __metadata('design:returntype', void 0)
], NgbModalWindow.prototype, "escKey", null);
NgbModalWindow = __decorate([
    Component({
        selector: 'ngb-modal-window',
        host: { 'class': 'modal', 'role': 'dialog', 'tabindex': '-1', 'style': 'display: block;' },
        template: `
        <div [class]="'modal-dialog' + (size ? ' modal-' + size : '')">
            <div class="modal-content" (click)="stopPropagation($event)">
                <ng-content></ng-content>
            </div>
        </div>
    `
    }), 
    __metadata('design:paramtypes', [])
], NgbModalWindow);
export const NGB_MODAL_WINDOW_DIRECTIVES = [NgbModalWindow];

//# sourceMappingURL=modal_window.js.map
