var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, ChangeDetectionStrategy, Input, Output, EventEmitter } from '@angular/core';
/**
 * A lightweight pager directive that is focused on providing previous/next paging functionality.
 */
export let NgbPager = class NgbPager {
    constructor() {
        this._currentPage = 0; // internal state
        /**
         *  A flag for determining whether links need to be aligned.
         */
        this.alignLinks = false;
        /**
         *  An event fired when the page is changed.
         *  Event's payload equals the current page.
         */
        this.pageChange = new EventEmitter();
    }
    prev() {
        if (this.hasPrev()) {
            this.pageChange.emit(--this._currentPage);
        }
    }
    next() {
        if (this.hasNext()) {
            this.pageChange.emit(++this._currentPage);
        }
    }
    hasPrev() { return this._currentPage > 0; }
    hasNext() { return this._currentPage < this.noOfPages - 1; }
    ngOnChanges() { this._currentPage = Math.max(Math.min(this.page, this.noOfPages - 1), 0); }
};
__decorate([
    // internal state
    Input(), 
    __metadata('design:type', Number)
], NgbPager.prototype, "noOfPages", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbPager.prototype, "page", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPager.prototype, "alignLinks", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbPager.prototype, "pageChange", void 0);
NgbPager = __decorate([
    Component({
        selector: 'ngb-pager',
        changeDetection: ChangeDetectionStrategy.OnPush,
        template: `
    <nav>
      <ul class="pager">
        <li [class.disabled]="!hasPrev()" [class.pager-prev]="alignLinks"><a (click)="prev()">Previous</a></li>
        <li [class.disabled]="!hasNext()" [class.pager-next]="alignLinks"><a (click)="next()">Next</a></li>
      </ul>
    </nav>
    `
    }), 
    __metadata('design:paramtypes', [])
], NgbPager);
export const NGB_PAGER_DIRECTIVES = [NgbPager];

//# sourceMappingURL=pager.js.map
