var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Directive, Input, ChangeDetectionStrategy, Injector, Renderer, ElementRef, TemplateRef, ViewContainerRef, ComponentFactoryResolver } from '@angular/core';
import { parseTriggers } from '../util/triggers';
import { Positioning } from '../util/positioning';
export let NgbPopoverWindow = class NgbPopoverWindow {
    constructor() {
        this.placement = 'top';
    }
};
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbPopoverWindow.prototype, "placement", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbPopoverWindow.prototype, "title", void 0);
NgbPopoverWindow = __decorate([
    Component({
        selector: 'ngb-popover-window',
        changeDetection: ChangeDetectionStrategy.OnPush,
        host: { '[class]': '"popover in popover-" + placement', 'role': 'tooltip' },
        template: `
    <div class="popover-arrow"></div>
    <h3 class="popover-title">{{title}}</h3><div class="popover-content"><ng-content></ng-content></div>
    `
    }), 
    __metadata('design:paramtypes', [])
], NgbPopoverWindow);
/**
 * A lightweight, extensible directive for fancy popover creation.
 */
export let NgbPopover = class NgbPopover {
    constructor(_elementRef, _viewContainerRef, _injector, _renderer, componentFactoryResolver) {
        this._elementRef = _elementRef;
        this._viewContainerRef = _viewContainerRef;
        this._injector = _injector;
        this._renderer = _renderer;
        /**
         * Placement of a popover. Accepts: "top", "bottom", "left", "right"
         */
        this.placement = 'top';
        /**
         * Specifies events that should trigger. Supports a space separated list of event names.
         */
        this.triggers = 'click';
        this._positioning = new Positioning();
        this._windowFactory = componentFactoryResolver.resolveComponentFactory(NgbPopoverWindow);
    }
    open() {
        if (!this._windowRef) {
            const nodes = this._getContentNodes();
            this._windowRef = this._viewContainerRef.createComponent(this._windowFactory, 0, this._injector, nodes);
            this._windowRef.instance.placement = this.placement;
            this._windowRef.instance.title = this.title;
        }
    }
    close() {
        if (this._windowRef) {
            this._viewContainerRef.remove(this._viewContainerRef.indexOf(this._windowRef.hostView));
            this._windowRef = null;
        }
    }
    toggle() {
        if (this._windowRef) {
            this.close();
        }
        else {
            this.open();
        }
    }
    ngOnInit() {
        const triggers = parseTriggers(this.triggers);
        if (triggers.length === 1 && triggers[0].isManual()) {
            return;
        }
        triggers.forEach((trigger) => {
            if (trigger.open === trigger.close) {
                this._renderer.listen(this._elementRef.nativeElement, trigger.open, () => { this.toggle(); });
            }
            else {
                this._renderer.listen(this._elementRef.nativeElement, trigger.open, () => { this.open(); });
                this._renderer.listen(this._elementRef.nativeElement, trigger.close, () => { this.close(); });
            }
        });
    }
    ngAfterViewChecked() {
        if (this._windowRef) {
            const targetPosition = this._positioning.positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, this.placement, false);
            const targetStyle = this._windowRef.location.nativeElement.style;
            targetStyle.top = `${targetPosition.top}px`;
            targetStyle.left = `${targetPosition.left}px`;
        }
    }
    _getContentNodes() {
        if (this.ngbPopover instanceof TemplateRef) {
            return [this._viewContainerRef.createEmbeddedView(this.ngbPopover).rootNodes];
        }
        else {
            return [[this._renderer.createText(null, `${this.ngbPopover}`)]];
        }
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPopover.prototype, "ngbPopover", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbPopover.prototype, "title", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPopover.prototype, "placement", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbPopover.prototype, "triggers", void 0);
NgbPopover = __decorate([
    Directive({ selector: '[ngbPopover]', exportAs: 'ngbPopover' }), 
    __metadata('design:paramtypes', [ElementRef, ViewContainerRef, Injector, Renderer, ComponentFactoryResolver])
], NgbPopover);
export const NGB_POPOVER_DIRECTIVES = [NgbPopover];

//# sourceMappingURL=popover.js.map
