var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, ChangeDetectionStrategy, Input, Output, EventEmitter } from '@angular/core';
/**
 * Rating directive that will take care of visualising a star rating bar.
 */
export let NgbRating = class NgbRating {
    constructor() {
        this.range = [];
        /**
         * Maximal rating that can be given using this widget.
         */
        this.max = 10;
        /**
         * A flag indicating if rating can be updated.
         */
        this.readonly = false;
        /**
         * An event fired when a user is hovering over a given rating.
         * Event's payload equals to the rating being hovered over.
         */
        this.hover = new EventEmitter();
        /**
         * An event fired when a user stops hovering over a given rating.
         * Event's payload equals to the rating of the last item being hovered over.
         */
        this.leave = new EventEmitter();
        /**
         * An event fired when a user selects a new rating.
         * Event's payload equals to the newly selected rating.
         */
        this.rateChange = new EventEmitter();
    }
    enter(value) {
        if (!this.readonly) {
            this.rate = value;
        }
        this.hover.emit(value);
    }
    ngOnInit() {
        this._oldRate = this.rate;
        this.range = this._buildTemplateObjects();
    }
    reset() {
        this.leave.emit(this.rate);
        this.rate = this._oldRate;
    }
    update(value) {
        if (!this.readonly) {
            this._oldRate = value;
            this.rate = value;
            this.rateChange.emit(value);
        }
    }
    _buildTemplateObjects() {
        let range = [];
        for (let i = 1; i <= this.max; i++) {
            range.push({ title: i });
        }
        return range;
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbRating.prototype, "max", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Number)
], NgbRating.prototype, "rate", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbRating.prototype, "readonly", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbRating.prototype, "hover", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbRating.prototype, "leave", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbRating.prototype, "rateChange", void 0);
NgbRating = __decorate([
    Component({
        selector: 'ngb-rating',
        changeDetection: ChangeDetectionStrategy.OnPush,
        template: `
    <span tabindex="0" (mouseleave)="reset()" aria-valuemin="0" [attr.aria-valuemax]="max" [attr.aria-valuenow]="rate">
      <template ngFor let-r [ngForOf]="range" let-index="index">
        <span class="sr-only">({{ index < rate ? '*' : ' ' }})</span>
        <span (mouseenter)="enter(index + 1)" (click)="update(index + 1)" [title]="r.title" 
        [attr.aria-valuetext]="r.title">{{ index < rate ? '&#9733;' : '&#9734;' }}</span>
      </template>
    </span>
  `
    }), 
    __metadata('design:paramtypes', [])
], NgbRating);
export const NGB_RATING_DIRECTIVES = [NgbRating];

//# sourceMappingURL=rating.js.map
