var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Directive, Input, ChangeDetectionStrategy, Injector, Renderer, ElementRef, TemplateRef, ViewContainerRef, ComponentFactoryResolver } from '@angular/core';
import { parseTriggers } from '../util/triggers';
import { Positioning } from '../util/positioning';
export let NgbTooltipWindow = class NgbTooltipWindow {
    constructor() {
        this.placement = 'top';
    }
};
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbTooltipWindow.prototype, "placement", void 0);
NgbTooltipWindow = __decorate([
    Component({
        selector: 'ngb-tooltip-window',
        changeDetection: ChangeDetectionStrategy.OnPush,
        host: { '[class]': '"tooltip in tooltip-" + placement', 'role': 'tooltip' },
        template: `
    <div class="tooltip-arrow"></div>
    <div class="tooltip-inner"><ng-content></ng-content></div>
    `
    }), 
    __metadata('design:paramtypes', [])
], NgbTooltipWindow);
/**
 * A lightweight, extensible directive for fancy tooltip creation.
 */
export let NgbTooltip = class NgbTooltip {
    constructor(_elementRef, _viewContainerRef, _injector, _renderer, componentFactoryResolver) {
        this._elementRef = _elementRef;
        this._viewContainerRef = _viewContainerRef;
        this._injector = _injector;
        this._renderer = _renderer;
        /**
         * Placement of a tooltip. Accepts: "top", "bottom", "left", "right"
         */
        this.placement = 'top';
        /**
         * Specifies events that should trigger. Supports a space separated list of event names.
         */
        this.triggers = 'hover';
        this._positioning = new Positioning();
        this._windowFactory = componentFactoryResolver.resolveComponentFactory(NgbTooltipWindow);
    }
    open() {
        if (!this._windowRef) {
            const nodes = this._getContentNodes();
            this._windowRef = this._viewContainerRef.createComponent(this._windowFactory, 0, this._injector, nodes);
            this._windowRef.instance.placement = this.placement;
        }
    }
    close() {
        if (this._windowRef) {
            this._viewContainerRef.remove(this._viewContainerRef.indexOf(this._windowRef.hostView));
            this._windowRef = null;
        }
    }
    toggle() {
        if (this._windowRef) {
            this.close();
        }
        else {
            this.open();
        }
    }
    ngOnInit() {
        const triggers = parseTriggers(this.triggers);
        if (triggers.length === 1 && triggers[0].isManual()) {
            return;
        }
        triggers.forEach((trigger) => {
            if (trigger.open === trigger.close) {
                this._renderer.listen(this._elementRef.nativeElement, trigger.open, () => { this.toggle(); });
            }
            else {
                this._renderer.listen(this._elementRef.nativeElement, trigger.open, () => { this.open(); });
                this._renderer.listen(this._elementRef.nativeElement, trigger.close, () => { this.close(); });
            }
        });
    }
    ngAfterViewChecked() {
        if (this._windowRef) {
            const targetPosition = this._positioning.positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, this.placement, false);
            const targetStyle = this._windowRef.location.nativeElement.style;
            targetStyle.top = `${targetPosition.top}px`;
            targetStyle.left = `${targetPosition.left}px`;
        }
    }
    _getContentNodes() {
        if (this.ngbTooltip instanceof TemplateRef) {
            return [this._viewContainerRef.createEmbeddedView(this.ngbTooltip).rootNodes];
        }
        else {
            return [[this._renderer.createText(null, `${this.ngbTooltip}`)]];
        }
    }
};
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTooltip.prototype, "ngbTooltip", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTooltip.prototype, "placement", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTooltip.prototype, "triggers", void 0);
NgbTooltip = __decorate([
    Directive({ selector: '[ngbTooltip]', exportAs: 'ngbTooltip' }), 
    __metadata('design:paramtypes', [ElementRef, ViewContainerRef, Injector, Renderer, ComponentFactoryResolver])
], NgbTooltip);
export const NGB_TOOLTIP_DIRECTIVES = [NgbTooltip];

//# sourceMappingURL=tooltip.js.map
