"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var modal_dismiss_reasons_1 = require('./modal_dismiss_reasons');
var NgbModalWindow = (function () {
    function NgbModalWindow() {
        this.backdrop = true;
        this.keyboard = true;
        this.closeEvent = new core_1.EventEmitter();
        this.dismissEvent = new core_1.EventEmitter();
    }
    NgbModalWindow.prototype.backdropClick = function () {
        if (this.backdrop) {
            this.dismiss(modal_dismiss_reasons_1.ModalDismissReasons.BACKDROP_CLICK);
        }
    };
    NgbModalWindow.prototype.escKey = function () {
        if (this.keyboard) {
            this.dismiss(modal_dismiss_reasons_1.ModalDismissReasons.ESC);
        }
    };
    NgbModalWindow.prototype.close = function (result) { this.closeEvent.emit(result); };
    NgbModalWindow.prototype.dismiss = function (reason) { this.dismissEvent.emit(reason); };
    NgbModalWindow.prototype.stopPropagation = function ($event) { $event.stopPropagation(); };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], NgbModalWindow.prototype, "backdrop", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], NgbModalWindow.prototype, "keyboard", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbModalWindow.prototype, "size", void 0);
    __decorate([
        core_1.Output('close'), 
        __metadata('design:type', Object)
    ], NgbModalWindow.prototype, "closeEvent", void 0);
    __decorate([
        core_1.Output('dismiss'), 
        __metadata('design:type', Object)
    ], NgbModalWindow.prototype, "dismissEvent", void 0);
    __decorate([
        core_1.HostListener('click'), 
        __metadata('design:type', Function), 
        __metadata('design:paramtypes', []), 
        __metadata('design:returntype', void 0)
    ], NgbModalWindow.prototype, "backdropClick", null);
    __decorate([
        core_1.HostListener('keyup.esc'), 
        __metadata('design:type', Function), 
        __metadata('design:paramtypes', []), 
        __metadata('design:returntype', void 0)
    ], NgbModalWindow.prototype, "escKey", null);
    NgbModalWindow = __decorate([
        core_1.Component({
            selector: 'ngb-modal-window',
            host: { 'class': 'modal', 'role': 'dialog', 'tabindex': '-1', 'style': 'display: block;' },
            template: "\n        <div [class]=\"'modal-dialog' + (size ? ' modal-' + size : '')\">\n            <div class=\"modal-content\" (click)=\"stopPropagation($event)\">\n                <ng-content></ng-content>\n            </div>\n        </div>\n    "
        }), 
        __metadata('design:paramtypes', [])
    ], NgbModalWindow);
    return NgbModalWindow;
}());
exports.NgbModalWindow = NgbModalWindow;
exports.NGB_MODAL_WINDOW_DIRECTIVES = [NgbModalWindow];

//# sourceMappingURL=modal_window.js.map
