import { OnChanges, EventEmitter } from '@angular/core';
/**
 * A lightweight pager directive that is focused on providing previous/next paging functionality.
 */
export declare class NgbPager implements OnChanges {
    private _currentPage;
    /**
     *  Number of pages present.
     */
    noOfPages: number;
    /**
     *  Current page.
     */
    page: number;
    /**
     *  A flag for determining whether links need to be aligned.
     */
    alignLinks: boolean;
    /**
     *  An event fired when the page is changed.
     *  Event's payload equals the current page.
     */
    pageChange: EventEmitter<{}>;
    prev(): void;
    next(): void;
    hasPrev(): boolean;
    hasNext(): boolean;
    ngOnChanges(): void;
}
export declare const NGB_PAGER_DIRECTIVES: typeof NgbPager[];
