"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
/**
 * A lightweight pager directive that is focused on providing previous/next paging functionality.
 */
var NgbPager = (function () {
    function NgbPager() {
        this._currentPage = 0; // internal state
        /**
         *  A flag for determining whether links need to be aligned.
         */
        this.alignLinks = false;
        /**
         *  An event fired when the page is changed.
         *  Event's payload equals the current page.
         */
        this.pageChange = new core_1.EventEmitter();
    }
    NgbPager.prototype.prev = function () {
        if (this.hasPrev()) {
            this.pageChange.emit(--this._currentPage);
        }
    };
    NgbPager.prototype.next = function () {
        if (this.hasNext()) {
            this.pageChange.emit(++this._currentPage);
        }
    };
    NgbPager.prototype.hasPrev = function () { return this._currentPage > 0; };
    NgbPager.prototype.hasNext = function () { return this._currentPage < this.noOfPages - 1; };
    NgbPager.prototype.ngOnChanges = function () { this._currentPage = Math.max(Math.min(this.page, this.noOfPages - 1), 0); };
    __decorate([
        // internal state
        core_1.Input(), 
        __metadata('design:type', Number)
    ], NgbPager.prototype, "noOfPages", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], NgbPager.prototype, "page", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPager.prototype, "alignLinks", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbPager.prototype, "pageChange", void 0);
    NgbPager = __decorate([
        core_1.Component({
            selector: 'ngb-pager',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            template: "\n    <nav>\n      <ul class=\"pager\">\n        <li [class.disabled]=\"!hasPrev()\" [class.pager-prev]=\"alignLinks\"><a (click)=\"prev()\">Previous</a></li>\n        <li [class.disabled]=\"!hasNext()\" [class.pager-next]=\"alignLinks\"><a (click)=\"next()\">Next</a></li>\n      </ul>\n    </nav>\n    "
        }), 
        __metadata('design:paramtypes', [])
    ], NgbPager);
    return NgbPager;
}());
exports.NgbPager = NgbPager;
exports.NGB_PAGER_DIRECTIVES = [NgbPager];

//# sourceMappingURL=pager.js.map
