import { EventEmitter, OnChanges } from '@angular/core';
/**
 * A directive that will take care of visualising a pagination bar and enable / disable buttons correctly!
 */
export declare class NgbPagination implements OnChanges {
    private _boundaryLinks;
    private _collectionSize;
    private _directionLinks;
    private _ellipses;
    private _maxSize;
    private _page;
    private _pageCount;
    private _pageSize;
    private _rotate;
    pages: number[];
    /**
     *  Whether to show the "First" and "Last" page links
     */
    boundaryLinks: boolean;
    /**
     *  Whether to show the "Next" and "Previous" page links
     */
    directionLinks: boolean;
    /**
     *  Whether to show ellipsis symbols and first/last page numbers when maxSize > number of pages
     */
    ellipses: boolean;
    /**
     *  Number of items in collection.
     */
    collectionSize: number | string;
    /**
     *  Maximum page numbers to be displayed
     */
    maxSize: number | string;
    /**
     *  Current page.
     */
    page: number | string;
    /**
     *  Number of items per page.
     */
    pageSize: number | string;
    /**
     *  An event fired when the page is changed.
     *  Event's payload equals the current page.
     */
    pageChange: EventEmitter<{}>;
    /**
     *  Whether to rotate pages when maxSize > number of pages.
     *  Current page will be in the middle
     */
    rotate: boolean;
    /**
     * Pagination display size: small or large
     */
    size: 'sm' | 'lg';
    hasPrevious(): boolean;
    hasNext(): boolean;
    selectPage(pageNumber: number): void;
    ngOnChanges(): void;
    /**
     * Appends ellipses and first/last page number to the displayed pages
     */
    private _applyEllipses(start, end);
    /**
     * Rotates page numbers based on maxSize items visible.
     * Currently selected page stays in the middle:
     *
     * Ex. for selected page = 6:
     * [5,*6*,7] for maxSize = 3
     * [4,5,*6*,7] for maxSize = 4
     */
    private _applyRotation();
    /**
     * Paginates page numbers based on maxSize items per page
     */
    private _applyPagination();
    private _isEllipsis(pageNumber);
    private _getPageNoInRange(newPageNo);
}
export declare const NGB_PAGINATION_DIRECTIVES: typeof NgbPagination[];
