import { OnInit, AfterViewChecked, Injector, Renderer, ElementRef, TemplateRef, ViewContainerRef, ComponentFactoryResolver } from '@angular/core';
export declare class NgbPopoverWindow {
    placement: string;
    title: string;
}
/**
 * A lightweight, extensible directive for fancy popover creation.
 */
export declare class NgbPopover implements OnInit, AfterViewChecked {
    private _elementRef;
    private _viewContainerRef;
    private _injector;
    private _renderer;
    /**
     * Content to be displayed as popover.
     */
    ngbPopover: string | TemplateRef<any>;
    /**
     * Title of a popover.
     */
    title: string;
    /**
     * Placement of a popover. Accepts: "top", "bottom", "left", "right"
     */
    placement: string;
    /**
     * Specifies events that should trigger. Supports a space separated list of event names.
     */
    triggers: string;
    private _positioning;
    private _windowFactory;
    private _windowRef;
    constructor(_elementRef: ElementRef, _viewContainerRef: ViewContainerRef, _injector: Injector, _renderer: Renderer, componentFactoryResolver: ComponentFactoryResolver);
    open(): void;
    close(): void;
    toggle(): void;
    ngOnInit(): void;
    ngAfterViewChecked(): void;
    private _getContentNodes();
}
export declare const NGB_POPOVER_DIRECTIVES: typeof NgbPopover[];
