"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var triggers_1 = require('../util/triggers');
var positioning_1 = require('../util/positioning');
var NgbPopoverWindow = (function () {
    function NgbPopoverWindow() {
        this.placement = 'top';
    }
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbPopoverWindow.prototype, "placement", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbPopoverWindow.prototype, "title", void 0);
    NgbPopoverWindow = __decorate([
        core_1.Component({
            selector: 'ngb-popover-window',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            host: { '[class]': '"popover in popover-" + placement', 'role': 'tooltip' },
            template: "\n    <div class=\"popover-arrow\"></div>\n    <h3 class=\"popover-title\">{{title}}</h3><div class=\"popover-content\"><ng-content></ng-content></div>\n    "
        }), 
        __metadata('design:paramtypes', [])
    ], NgbPopoverWindow);
    return NgbPopoverWindow;
}());
exports.NgbPopoverWindow = NgbPopoverWindow;
/**
 * A lightweight, extensible directive for fancy popover creation.
 */
var NgbPopover = (function () {
    function NgbPopover(_elementRef, _viewContainerRef, _injector, _renderer, componentFactoryResolver) {
        this._elementRef = _elementRef;
        this._viewContainerRef = _viewContainerRef;
        this._injector = _injector;
        this._renderer = _renderer;
        /**
         * Placement of a popover. Accepts: "top", "bottom", "left", "right"
         */
        this.placement = 'top';
        /**
         * Specifies events that should trigger. Supports a space separated list of event names.
         */
        this.triggers = 'click';
        this._positioning = new positioning_1.Positioning();
        this._windowFactory = componentFactoryResolver.resolveComponentFactory(NgbPopoverWindow);
    }
    NgbPopover.prototype.open = function () {
        if (!this._windowRef) {
            var nodes = this._getContentNodes();
            this._windowRef = this._viewContainerRef.createComponent(this._windowFactory, 0, this._injector, nodes);
            this._windowRef.instance.placement = this.placement;
            this._windowRef.instance.title = this.title;
        }
    };
    NgbPopover.prototype.close = function () {
        if (this._windowRef) {
            this._viewContainerRef.remove(this._viewContainerRef.indexOf(this._windowRef.hostView));
            this._windowRef = null;
        }
    };
    NgbPopover.prototype.toggle = function () {
        if (this._windowRef) {
            this.close();
        }
        else {
            this.open();
        }
    };
    NgbPopover.prototype.ngOnInit = function () {
        var _this = this;
        var triggers = triggers_1.parseTriggers(this.triggers);
        if (triggers.length === 1 && triggers[0].isManual()) {
            return;
        }
        triggers.forEach(function (trigger) {
            if (trigger.open === trigger.close) {
                _this._renderer.listen(_this._elementRef.nativeElement, trigger.open, function () { _this.toggle(); });
            }
            else {
                _this._renderer.listen(_this._elementRef.nativeElement, trigger.open, function () { _this.open(); });
                _this._renderer.listen(_this._elementRef.nativeElement, trigger.close, function () { _this.close(); });
            }
        });
    };
    NgbPopover.prototype.ngAfterViewChecked = function () {
        if (this._windowRef) {
            var targetPosition = this._positioning.positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, this.placement, false);
            var targetStyle = this._windowRef.location.nativeElement.style;
            targetStyle.top = targetPosition.top + "px";
            targetStyle.left = targetPosition.left + "px";
        }
    };
    NgbPopover.prototype._getContentNodes = function () {
        if (this.ngbPopover instanceof core_1.TemplateRef) {
            return [this._viewContainerRef.createEmbeddedView(this.ngbPopover).rootNodes];
        }
        else {
            return [[this._renderer.createText(null, "" + this.ngbPopover)]];
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPopover.prototype, "ngbPopover", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbPopover.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPopover.prototype, "placement", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbPopover.prototype, "triggers", void 0);
    NgbPopover = __decorate([
        core_1.Directive({ selector: '[ngbPopover]', exportAs: 'ngbPopover' }), 
        __metadata('design:paramtypes', [core_1.ElementRef, core_1.ViewContainerRef, core_1.Injector, core_1.Renderer, core_1.ComponentFactoryResolver])
    ], NgbPopover);
    return NgbPopover;
}());
exports.NgbPopover = NgbPopover;
exports.NGB_POPOVER_DIRECTIVES = [NgbPopover];

//# sourceMappingURL=popover.js.map
