"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var util_1 = require('../util/util');
/**
 * Directive that can be used to provide feedback on the progress of a workflow or an action.
 */
var NgbProgressbar = (function () {
    function NgbProgressbar() {
        /**
         * Maximal value to be displayed in the progressbar.
         */
        this.max = 100;
        /**
         * A flag indicating if a progress bar should be animated when the value changes. Takes effect only for browsers
         * supporting CSS3 animations.
         */
        this.animated = false;
        /**
         * A flag indicating if a progress bar should be displayed as striped.
         */
        this.striped = false;
        /**
         * Current value to be displayed in the progressbar. Should be smaller or equal to "max" value.
         */
        this.value = 0;
    }
    NgbProgressbar.prototype.isAnimated = function () { return util_1.toBoolean(this.animated); };
    NgbProgressbar.prototype.isStriped = function () { return util_1.toBoolean(this.striped); };
    NgbProgressbar.prototype.getValue = function () { return util_1.getValueInRange(this.value, this.max); };
    NgbProgressbar.prototype.getPercentValue = function () { return 100 * this.getValue() / this.max; };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbProgressbar.prototype, "max", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbProgressbar.prototype, "animated", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbProgressbar.prototype, "striped", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbProgressbar.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbProgressbar.prototype, "value", void 0);
    NgbProgressbar = __decorate([
        core_1.Component({
            selector: 'ngb-progressbar',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            template: "\n    <progress class=\"progress {{isAnimated() && 'progress-animated'}} {{isStriped() && 'progress-striped'}} {{type && 'progress-' + type}}\"\n      [value]=\"getValue()\" [max]=\"max\">\n      <div class=\"progress\">\n        <span class=\"progress-bar\" [style.width.%]=\"getPercentValue()\"><ng-content></ng-content></span>\n      </div>\n    </progress>\n  "
        }), 
        __metadata('design:paramtypes', [])
    ], NgbProgressbar);
    return NgbProgressbar;
}());
exports.NgbProgressbar = NgbProgressbar;
exports.NGB_PROGRESSBAR_DIRECTIVES = [NgbProgressbar];

//# sourceMappingURL=progressbar.js.map
