"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var triggers_1 = require('../util/triggers');
var positioning_1 = require('../util/positioning');
var NgbTooltipWindow = (function () {
    function NgbTooltipWindow() {
        this.placement = 'top';
    }
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbTooltipWindow.prototype, "placement", void 0);
    NgbTooltipWindow = __decorate([
        core_1.Component({
            selector: 'ngb-tooltip-window',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            host: { '[class]': '"tooltip in tooltip-" + placement', 'role': 'tooltip' },
            template: "\n    <div class=\"tooltip-arrow\"></div>\n    <div class=\"tooltip-inner\"><ng-content></ng-content></div>\n    "
        }), 
        __metadata('design:paramtypes', [])
    ], NgbTooltipWindow);
    return NgbTooltipWindow;
}());
exports.NgbTooltipWindow = NgbTooltipWindow;
/**
 * A lightweight, extensible directive for fancy tooltip creation.
 */
var NgbTooltip = (function () {
    function NgbTooltip(_elementRef, _viewContainerRef, _injector, _renderer, componentFactoryResolver) {
        this._elementRef = _elementRef;
        this._viewContainerRef = _viewContainerRef;
        this._injector = _injector;
        this._renderer = _renderer;
        /**
         * Placement of a tooltip. Accepts: "top", "bottom", "left", "right"
         */
        this.placement = 'top';
        /**
         * Specifies events that should trigger. Supports a space separated list of event names.
         */
        this.triggers = 'hover';
        this._positioning = new positioning_1.Positioning();
        this._windowFactory = componentFactoryResolver.resolveComponentFactory(NgbTooltipWindow);
    }
    NgbTooltip.prototype.open = function () {
        if (!this._windowRef) {
            var nodes = this._getContentNodes();
            this._windowRef = this._viewContainerRef.createComponent(this._windowFactory, 0, this._injector, nodes);
            this._windowRef.instance.placement = this.placement;
        }
    };
    NgbTooltip.prototype.close = function () {
        if (this._windowRef) {
            this._viewContainerRef.remove(this._viewContainerRef.indexOf(this._windowRef.hostView));
            this._windowRef = null;
        }
    };
    NgbTooltip.prototype.toggle = function () {
        if (this._windowRef) {
            this.close();
        }
        else {
            this.open();
        }
    };
    NgbTooltip.prototype.ngOnInit = function () {
        var _this = this;
        var triggers = triggers_1.parseTriggers(this.triggers);
        if (triggers.length === 1 && triggers[0].isManual()) {
            return;
        }
        triggers.forEach(function (trigger) {
            if (trigger.open === trigger.close) {
                _this._renderer.listen(_this._elementRef.nativeElement, trigger.open, function () { _this.toggle(); });
            }
            else {
                _this._renderer.listen(_this._elementRef.nativeElement, trigger.open, function () { _this.open(); });
                _this._renderer.listen(_this._elementRef.nativeElement, trigger.close, function () { _this.close(); });
            }
        });
    };
    NgbTooltip.prototype.ngAfterViewChecked = function () {
        if (this._windowRef) {
            var targetPosition = this._positioning.positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, this.placement, false);
            var targetStyle = this._windowRef.location.nativeElement.style;
            targetStyle.top = targetPosition.top + "px";
            targetStyle.left = targetPosition.left + "px";
        }
    };
    NgbTooltip.prototype._getContentNodes = function () {
        if (this.ngbTooltip instanceof core_1.TemplateRef) {
            return [this._viewContainerRef.createEmbeddedView(this.ngbTooltip).rootNodes];
        }
        else {
            return [[this._renderer.createText(null, "" + this.ngbTooltip)]];
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTooltip.prototype, "ngbTooltip", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTooltip.prototype, "placement", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTooltip.prototype, "triggers", void 0);
    NgbTooltip = __decorate([
        core_1.Directive({ selector: '[ngbTooltip]', exportAs: 'ngbTooltip' }), 
        __metadata('design:paramtypes', [core_1.ElementRef, core_1.ViewContainerRef, core_1.Injector, core_1.Renderer, core_1.ComponentFactoryResolver])
    ], NgbTooltip);
    return NgbTooltip;
}());
exports.NgbTooltip = NgbTooltip;
exports.NGB_TOOLTIP_DIRECTIVES = [NgbTooltip];

//# sourceMappingURL=tooltip.js.map
