"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var core_1 = require('@angular/core');
var common_1 = require('@angular/common');
var NGB_RADIO_VALUE_ACCESSOR = {
    provide: common_1.NG_VALUE_ACCESSOR,
    useExisting: core_1.forwardRef(function () { return NgbRadioGroup; }),
    multi: true
};
/**
 * Easily create Bootstrap-style radio buttons. A value of a selected button is bound to a variable
 * specified via ngModel.
 */
var NgbRadioGroup = (function () {
    function NgbRadioGroup() {
        this._radios = new Set();
        this._value = null;
        this.onChange = function (_) { };
        this.onTouched = function () { };
    }
    NgbRadioGroup.prototype.onRadioChange = function (radio) {
        this.writeValue(radio.value);
        this.onChange(radio.value);
    };
    NgbRadioGroup.prototype.onRadioValueUpdate = function () { this._updateRadios(); };
    NgbRadioGroup.prototype.register = function (radio) { this._radios.add(radio); };
    NgbRadioGroup.prototype.registerOnChange = function (fn) { this.onChange = fn; };
    NgbRadioGroup.prototype.registerOnTouched = function (fn) { this.onTouched = fn; };
    NgbRadioGroup.prototype.unregister = function (radio) { this._radios.delete(radio); };
    NgbRadioGroup.prototype.writeValue = function (value) {
        this._value = value;
        this._updateRadios();
    };
    NgbRadioGroup.prototype._updateRadios = function () {
        var _this = this;
        this._radios.forEach(function (radio) { return radio.markChecked(_this._value); });
    };
    NgbRadioGroup = __decorate([
        core_1.Directive({
            selector: '[ngbRadioGroup]',
            host: { 'data-toggle': 'buttons', 'class': 'btn-group' },
            providers: [NGB_RADIO_VALUE_ACCESSOR]
        }), 
        __metadata('design:paramtypes', [])
    ], NgbRadioGroup);
    return NgbRadioGroup;
}());
exports.NgbRadioGroup = NgbRadioGroup;
var NgbRadioLabel = (function () {
    function NgbRadioLabel() {
    }
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], NgbRadioLabel.prototype, "checked", void 0);
    NgbRadioLabel = __decorate([
        core_1.Directive({ selector: 'label.btn', host: { '[class.active]': 'checked' } }), 
        __metadata('design:paramtypes', [])
    ], NgbRadioLabel);
    return NgbRadioLabel;
}());
exports.NgbRadioLabel = NgbRadioLabel;
/**
 * Marks an input of type "radio" as part of the NgbRadioGroup.
 */
var NgbRadio = (function () {
    function NgbRadio(_group, _label, _renderer, _element) {
        this._group = _group;
        this._label = _label;
        this._renderer = _renderer;
        this._element = _element;
        this._value = null;
        if (this._group) {
            this._group.register(this);
        }
    }
    Object.defineProperty(NgbRadio.prototype, "value", {
        get: function () { return this._value; },
        /**
         * You can specify model value of a given radio by binding to the value property.
        */
        set: function (value) {
            this._value = value;
            var stringValue = value ? value.toString() : '';
            this._renderer.setElementProperty(this._element.nativeElement, 'value', stringValue);
            if (this._group) {
                this._group.onRadioValueUpdate();
            }
        },
        enumerable: true,
        configurable: true
    });
    NgbRadio.prototype.markChecked = function (value) {
        this._checked = (this.value === value && value !== null);
        this._label.checked = this._checked;
    };
    NgbRadio.prototype.ngOnDestroy = function () {
        if (this._group) {
            this._group.unregister(this);
        }
    };
    NgbRadio.prototype.onChange = function () {
        if (this._group) {
            this._group.onRadioChange(this);
        }
    };
    __decorate([
        core_1.Input('value'), 
        __metadata('design:type', Object), 
        __metadata('design:paramtypes', [Object])
    ], NgbRadio.prototype, "value", null);
    NgbRadio = __decorate([
        core_1.Directive({ selector: 'input[type=radio]', host: { '(change)': 'onChange($event.target.value)', '[checked]': '_checked' } }),
        __param(0, core_1.Optional()),
        __param(1, core_1.Optional()), 
        __metadata('design:paramtypes', [NgbRadioGroup, NgbRadioLabel, core_1.Renderer, core_1.ElementRef])
    ], NgbRadio);
    return NgbRadio;
}());
exports.NgbRadio = NgbRadio;
exports.NGB_RADIO_DIRECTIVES = [NgbRadio, NgbRadioLabel, NgbRadioGroup];

//# sourceMappingURL=radio.js.map
