import { QueryList, TemplateRef, EventEmitter, AfterContentChecked } from '@angular/core';
/**
 * This directive should be used to wrap accordion panel titles that need to contain HTML markup or other directives.
 */
export declare class NgbPanelTitle {
    templateRef: TemplateRef<any>;
    constructor(templateRef: TemplateRef<any>);
}
/**
 * This directive must be used to wrap accordion panel content.
 */
export declare class NgbPanelContent {
    templateRef: TemplateRef<any>;
    constructor(templateRef: TemplateRef<any>);
}
/**
 * The NgbPanel directive represents an in individual panel with the title and collapsible
 * content
 */
export declare class NgbPanel {
    /**
     *  A flag determining whether the panel is disabled or not.
     *  When disabled, the panel cannot be toggled.
     */
    disabled: boolean;
    /**
     *  An optional id for the panel. The id should be unique.
     *  If not provided, it will be auto-generated.
     */
    id: string;
    /**
     *  The title for the panel.
     */
    title: string;
    /**
     *  Panel type (CSS class). Bootstrap 4 recognizes the following types: "success", "info", "warning" and "danger".
     */
    type: string;
    contentTpl: NgbPanelContent;
    titleTpl: NgbPanelTitle;
}
/**
 * The payload of the panel change event
 */
export interface NgbPanelChangeEvent {
    panelId: string;
    nextState: boolean;
    preventDefault(): any;
}
/**
 * The NgbAccordion directive is a collection of panels.
 * It can assure that only panel can be opened at a time.
 */
export declare class NgbAccordion implements AfterContentChecked {
    _panels: QueryList<NgbPanel>;
    /**
     * An array or comma separated strings of panel identifiers that should be opened
     */
    activeIds: string | string[];
    /**
     *  Whether the other panels should be closed when a panel is opened
     */
    closeOtherPanels: boolean;
    /**
     *  Type of accordion's panels. Bootstrap 4 recognizes the following types: "success", "info", "warning" and "danger".
     */
    type: string;
    /**
     * A panel change event fired right before the panel toggle happens. The event object has three properties:
     * 'panelId', the id of panel that id toggled, 'nextState' whether panel will be opened (true) or closed (false),
     * and a function, 'preventDefault()' which, when executed, will prevent the panel toggle from occurring.
     */
    change: EventEmitter<NgbPanelChangeEvent>;
    /**
     * A map that stores each panel state
     */
    private _states;
    /**
     * A map that stores references to all panels
     */
    private _panelRefs;
    ngAfterContentChecked(): void;
    toggle(panelId: string): void;
    private _closeOthers(panelId);
    private _isOpen(panelId);
    private _updateActiveIds();
    private _updateStates();
}
export declare const NGB_ACCORDION_DIRECTIVES: (typeof NgbAccordion | typeof NgbPanel | typeof NgbPanelTitle)[];
