var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Component, Input, ContentChildren, QueryList, Directive, TemplateRef, ContentChild, Output, EventEmitter } from '@angular/core';
let nextId = 0;
/**
 * This directive should be used to wrap tab titles that need to contain HTML markup or other directives.
 */
export let NgbTabTitle = class NgbTabTitle {
    constructor(templateRef) {
        this.templateRef = templateRef;
    }
};
NgbTabTitle = __decorate([
    Directive({ selector: 'template[ngbTabTitle]' }), 
    __metadata('design:paramtypes', [TemplateRef])
], NgbTabTitle);
/**
 * This directive must be used to wrap content to be displayed in a tab.
 */
export let NgbTabContent = class NgbTabContent {
    constructor(templateRef) {
        this.templateRef = templateRef;
    }
};
NgbTabContent = __decorate([
    Directive({ selector: 'template[ngbTabContent]' }), 
    __metadata('design:paramtypes', [TemplateRef])
], NgbTabContent);
/**
 * A directive representing an individual tab.
 */
export let NgbTab = class NgbTab {
    constructor() {
        /**
         * Unique tab identifier. Must be unique for the entire document for proper accessibility support.
         */
        this.id = `ngb-tab-${nextId++}`;
        /**
         * Allows toggling disabled state of a given state. Disabled tabs can't be selected.
         */
        this.disabled = false;
    }
};
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbTab.prototype, "id", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbTab.prototype, "title", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTab.prototype, "disabled", void 0);
__decorate([
    ContentChild(NgbTabContent), 
    __metadata('design:type', NgbTabContent)
], NgbTab.prototype, "contentTpl", void 0);
__decorate([
    ContentChild(NgbTabTitle), 
    __metadata('design:type', NgbTabTitle)
], NgbTab.prototype, "titleTpl", void 0);
NgbTab = __decorate([
    Directive({ selector: 'ngb-tab' }), 
    __metadata('design:paramtypes', [])
], NgbTab);
/**
 * A component that makes it easy to create tabbed interface.
 */
export let NgbTabset = class NgbTabset {
    constructor() {
        /**
         * Type of navigation to be used for tabs. Can be one of 'tabs' or 'pills'.
         */
        this.type = 'tabs';
        /**
         * A tab change event fired right before the tab selection happens.  The event object has three properties:
         * 'activeId', the id of the currently active tab, 'nextId' the id of the newly selected tab, and a function,
         * 'preventDefault()' which, when executed, will prevent the tab change from occurring.
         */
        this.change = new EventEmitter();
    }
    select(tabIdx) {
        let selectedTab = this._getTabById(tabIdx);
        if (selectedTab && !selectedTab.disabled && this.activeId !== selectedTab.id) {
            let defaultPrevented = false;
            this.change.emit({ activeId: this.activeId, nextId: selectedTab.id, preventDefault: () => { defaultPrevented = true; } });
            if (!defaultPrevented) {
                this.activeId = selectedTab.id;
            }
        }
    }
    ngAfterContentChecked() {
        // auto-correct activeId that might have been set incorrectly as input
        let activeTab = this._getTabById(this.activeId);
        this.activeId = activeTab ? activeTab.id : (this.tabs.length ? this.tabs.first.id : null);
    }
    _getTabById(id) {
        let tabsWithId = this.tabs.filter(tab => tab.id === id);
        return tabsWithId.length ? tabsWithId[0] : null;
    }
};
__decorate([
    ContentChildren(NgbTab), 
    __metadata('design:type', QueryList)
], NgbTabset.prototype, "tabs", void 0);
__decorate([
    Input(), 
    __metadata('design:type', String)
], NgbTabset.prototype, "activeId", void 0);
__decorate([
    Input(), 
    __metadata('design:type', Object)
], NgbTabset.prototype, "type", void 0);
__decorate([
    Output(), 
    __metadata('design:type', Object)
], NgbTabset.prototype, "change", void 0);
NgbTabset = __decorate([
    Component({
        selector: 'ngb-tabset',
        exportAs: 'ngbTabset',
        template: `
    <ul [class]="'nav nav-' + type" role="tablist">
      <li class="nav-item" *ngFor="let tab of tabs">
        <a [id]="tab.id" class="nav-link" [class.active]="tab.id === activeId" [class.disabled]="tab.disabled" 
          href (click)="!!select(tab.id)">
          {{tab.title}}<template [ngTemplateOutlet]="tab.titleTpl?.templateRef"></template>
        </a>
      </li>
    </ul>
    <div class="tab-content">
      <template ngFor let-tab [ngForOf]="tabs">
        <div class="tab-pane active" *ngIf="tab.id === activeId" role="tabpanel" [attr.aria-labelledby]="tab.id">
          <template [ngTemplateOutlet]="tab.contentTpl.templateRef"></template>
        </div>
      </template>
    </div>
  `
    }), 
    __metadata('design:paramtypes', [])
], NgbTabset);
export const NGB_TABSET_DIRECTIVES = [NgbTabset, NgbTab, NgbTabContent, NgbTabTitle];

//# sourceMappingURL=tabset.js.map
